"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsRedirect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _store = require("../../../common/store");
var _format_page_filter_search_param = require("../../../../common/utils/format_page_filter_search_param");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/pages/alerts/alert_details_redirect.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertDetailsRedirect = () => {
  var _searchParams$get;
  const {
    alertId
  } = (0, _reactRouterDom.useParams)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const searchParams = new URLSearchParams(search);
  const timestamp = searchParams.get('timestamp');
  // Although we use the 'default' space here when an index isn't provided or accidentally deleted
  // It's a safe catch all as we reset the '.internal.alerts-*` indices with the correct space in the flyout
  // Here: x-pack/solutions/security/plugins/security_solution/public/common/components/event_details/helpers.tsx
  const index = (_searchParams$get = searchParams.get('index')) !== null && _searchParams$get !== void 0 ? _searchParams$get : `.internal${_constants.DEFAULT_ALERTS_INDEX}-default`;
  const getInputSelector = (0, _react.useMemo)(() => _store.inputsSelectors.inputsSelector(), []);
  const inputState = (0, _reactRedux.useSelector)(getInputSelector);
  const {
    linkTo: globalLinkTo,
    timerange: globalTimerange
  } = inputState.global;
  const {
    linkTo: timelineLinkTo,
    timerange: timelineTimerange
  } = inputState.timeline;

  // Default to the existing global timerange if we don't get this query param for whatever reason
  const fromTime = timestamp !== null && timestamp !== void 0 ? timestamp : globalTimerange.from;
  // Add 5 minutes to the alert timestamp as the alert table is non-inclusive of the end time
  // This also provides padding time if the user clears the `_id` filter after redirect to see other alerts
  const toTime = (0, _moment.default)(timestamp !== null && timestamp !== void 0 ? timestamp : globalTimerange.to).add('5', 'minutes');
  const timerange = (0, _rison.encode)({
    global: {
      [_use_url_state.URL_PARAM_KEY.timerange]: {
        kind: 'absolute',
        from: fromTime,
        to: toTime
      },
      linkTo: globalLinkTo
    },
    timeline: {
      [_use_url_state.URL_PARAM_KEY.timerange]: timelineTimerange,
      linkTo: timelineLinkTo
    }
  });
  const kqlAppQuery = (0, _rison.encode)({
    language: 'kuery',
    query: `_id: ${alertId}`
  });
  const statusPageFilter = {
    fieldName: _ruleDataUtils.ALERT_WORKFLOW_STATUS,
    title: 'Status',
    selectedOptions: [],
    existsSelected: false
  };
  const pageFiltersQuery = (0, _rison.encode)((0, _format_page_filter_search_param.formatPageFilterSearchParam)([statusPageFilter]));
  const currentFlyoutParams = searchParams.get(_use_url_state.URL_PARAM_KEY.flyout);
  const urlParams = new URLSearchParams({
    [_use_url_state.URL_PARAM_KEY.appQuery]: kqlAppQuery,
    [_use_url_state.URL_PARAM_KEY.timerange]: timerange,
    [_use_url_state.URL_PARAM_KEY.pageFilter]: pageFiltersQuery,
    [_use_url_state.URL_PARAM_KEY.flyout]: (0, _utils.resolveFlyoutParams)({
      index,
      alertId
    }, currentFlyoutParams)
  });
  const url = `${_constants.ALERTS_PATH}?${urlParams.toString()}`;
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 10
    }
  });
};
exports.AlertDetailsRedirect = AlertDetailsRedirect;