"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.CONTENT_TEST_ID = exports.AttacksPageContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _schedule = require("../../../attack_discovery/pages/header/schedule");
var _translations = require("../../pages/attacks/translations");
var _header_page = require("../../../common/components/header_page");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _display = require("../../../explore/hosts/pages/display");
var _search_bar_section = require("./search_bar/search_bar_section");
var _schedule_flyout = require("./schedule_flyout");
var _table_section = require("./table/table_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/attacks/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CONTENT_TEST_ID = exports.CONTENT_TEST_ID = 'attacks-page-content';
const SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = exports.SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID = 'attacks-page-security-solution-page-wrapper';

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
/**
 * Renders the content of the attacks page: search bar, header, filters, KPIs, and table sections.
 */
const AttacksPageContent = exports.AttacksPageContent = /*#__PURE__*/_react.default.memo(({
  dataView
}) => {
  const containerElement = (0, _react.useRef)(null);
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();

  // showing / hiding the flyout:
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const openFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(true);
  }, []);
  const onClose = (0, _react.useCallback)(() => setShowFlyout(false), []);
  return /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    "data-test-subj": CONTENT_TEST_ID,
    ref: containerElement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_search_bar_section.SearchBarSection, {
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": SECURITY_SOLUTION_PAGE_WRAPPER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: _translations.PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_schedule.Schedule, {
    openFlyout: openFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_table_section.TableSection, {
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), showFlyout && /*#__PURE__*/_react.default.createElement(_schedule_flyout.SchedulesFlyout, {
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 24
    }
  })));
});
AttacksPageContent.displayName = 'AttacksPageContent';