"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _response_actions_list = require("./response_actions_list");
var _response_action_add_button = require("./response_action_add_button");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/response_actions_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResponseActionsWrapper = exports.ResponseActionsWrapper = /*#__PURE__*/_react.default.memo(({
  items,
  removeItem,
  supportedResponseActionTypes,
  addItem
}) => {
  const actionTypeIdRef = (0, _react.useRef)(null);
  const updateActionTypeId = (0, _react.useCallback)(id => {
    actionTypeIdRef.current = id;
  }, []);
  const context = (0, _shared_imports.useFormContext)();
  const renderButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_response_action_add_button.ResponseActionAddButton, {
      supportedResponseActionTypes: supportedResponseActionTypes,
      addActionType: addItem,
      updateActionTypeId: updateActionTypeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    });
  }, [addItem, updateActionTypeId, supportedResponseActionTypes]);
  (0, _react.useEffect)(() => {
    if (actionTypeIdRef.current) {
      const index = items.length - 1;
      const path = `responseActions[${index}].actionTypeId`;
      context.setFieldValue(path, actionTypeIdRef.current);
      actionTypeIdRef.current = null;
    }
  }, [context, items.length]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "response-actions-wrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_response_actions_list.ResponseActionsList, {
    items: items,
    removeItem: removeItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }), renderButton);
});
ResponseActionsWrapper.displayName = 'ResponseActionsWrapper';