"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmRulesUpgrade = void 0;
exports.useUpgradeWithConflictsModal = useUpgradeWithConflictsModal;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _use_async_confirmation = require("../../rules_table/use_async_confirmation");
var _upgrade_modal = require("./upgrade_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_upgrade_with_conflicts_modal/use_upgrade_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let ConfirmRulesUpgrade = exports.ConfirmRulesUpgrade = /*#__PURE__*/function (ConfirmRulesUpgrade) {
  ConfirmRulesUpgrade["WithoutConflicts"] = "WithoutConflicts";
  ConfirmRulesUpgrade["WithSolvableConflicts"] = "WithSolvableConflicts";
  return ConfirmRulesUpgrade;
}({});
function useUpgradeWithConflictsModal() {
  const [isVisible, {
    on: showModal,
    off: hideModal
  }] = (0, _reactHooks.useBoolean)(false);
  const [initConfirmation, confirm, cancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showModal,
    onFinish: hideModal
  });
  const [rulesUpgradeConflictsStats, setRulesUpgradeConflictsStats] = (0, _react.useState)({
    numOfRulesWithoutConflicts: 0,
    numOfRulesWithSolvableConflicts: 0,
    numOfRulesWithNonSolvableConflicts: 0
  });
  const confirmConflictsUpgrade = (0, _react.useCallback)(conflictsStats => {
    setRulesUpgradeConflictsStats(conflictsStats);
    return initConfirmation();
  }, [initConfirmation]);
  return {
    modal: isVisible && /*#__PURE__*/_react.default.createElement(_upgrade_modal.UpgradeWithConflictsModal, (0, _extends2.default)({}, rulesUpgradeConflictsStats, {
      onConfirm: confirm,
      onCancel: cancel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    })),
    confirmConflictsUpgrade
  };
}