"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsFilterPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../common/translations"));
var _toggle_selected_group = require("../../../../../common/components/ml_popover/jobs_table/filters/toggle_selected_group");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table_filters/tags_filter_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAGS_POPOVER_WIDTH = 500;
/**
 * Popover for selecting tags to filter on
 *
 * @param tags to display for filtering
 * @param onSelectedTagsChanged change listener to be notified when tag selection changes
 */
const TagsFilterPopoverComponent = ({
  tags,
  selectedTags,
  onSelectedTagsChanged
}) => {
  const sortedTags = (0, _react.useMemo)(() => (0, _helpers.caseInsensitiveSort)(Array.from(new Set([...tags, ...selectedTags]))), [selectedTags, tags]);
  const [isTagPopoverOpen, setIsTagPopoverOpen] = (0, _react.useState)(false);
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)(() => {
    const selectedTagsSet = new Set(selectedTags);
    return sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
  });
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    setSelectableOptions(newOptions);
    (0, _toggle_selected_group.toggleSelectedGroup)(changedOption.label, selectedTags, onSelectedTagsChanged);
  };
  (0, _react.useEffect)(() => {
    const selectedTagsSet = new Set(selectedTags);
    const newSelectableOptions = sortedTags.map(label => ({
      label,
      checked: selectedTagsSet.has(label) ? 'on' : undefined
    }));
    setSelectableOptions(newSelectableOptions);
  }, [sortedTags, selectedTags]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    numFilters: tags.length,
    isSelected: isTagPopoverOpen,
    hasActiveFilters: selectedTags.length > 0,
    numActiveFilters: selectedTags.length,
    "data-test-subj": "tags-filter-popover-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, i18n.TAGS);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isTagPopoverOpen,
    closePopover: () => setIsTagPopoverOpen(!isTagPopoverOpen),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': 'tags-filter-popover'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    searchable: true,
    searchProps: {
      placeholder: i18n.SEARCH_TAGS
    },
    "aria-label": i18n.RULES_TAG_SEARCH,
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    emptyMessage: i18n.NO_TAGS_AVAILABLE,
    noMatchesMessage: i18n.NO_TAGS_AVAILABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: TAGS_POPOVER_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, search), list)));
};
TagsFilterPopoverComponent.displayName = 'TagsFilterPopoverComponent';
const TagsFilterPopover = exports.TagsFilterPopover = /*#__PURE__*/_react.default.memo(TagsFilterPopoverComponent);
TagsFilterPopover.displayName = 'TagsFilterPopover';