"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/auto_refresh_button/auto_refresh_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * AutoRefreshButton - component for toggling auto-refresh setting.
 *
 * @param isRefreshOn whether or not auto refresh is enabled
 * @param isDisabled whether or not component is in disabled state
 * @param reFetchRules action for re-fetching rules
 * @param setIsRefreshOn action for enabling/disabling refresh
 */
const AutoRefreshButtonComponent = ({
  isRefreshOn,
  isDisabled,
  reFetchRules,
  setIsRefreshOn
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), [setIsPopoverOpen]);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevState => !prevState), [setIsPopoverOpen]);
  const handleAutoRefreshSwitch = (0, _react.useCallback)(e => {
    const refreshOn = e.target.checked;
    if (refreshOn) {
      reFetchRules();
    }
    setIsRefreshOn(refreshOn);
    closePopover();
  }, [reFetchRules, setIsRefreshOn, closePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "autoRefreshButton",
      color: 'text',
      iconType: 'timeRefresh',
      onClick: togglePopover,
      disabled: isDisabled,
      css: (0, _react2.css)`
            margin-left: 10px;
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }, isRefreshOn ? 'On' : 'Off'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      key: "allRulesAutoRefreshSwitch",
      label: i18n.REFRESH_RULE_POPOVER_DESCRIPTION,
      checked: isRefreshOn !== null && isRefreshOn !== void 0 ? isRefreshOn : false,
      onChange: handleAutoRefreshSwitch,
      compressed: true,
      disabled: isDisabled,
      "data-test-subj": "refreshSettingsSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }), ...(isDisabled ? [/*#__PURE__*/_react.default.createElement("div", {
      key: "refreshSettingsSelectionNote",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      "data-test-subj": "refreshSettingsSelectionNote",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rules.refreshRulePopoverSelectionHelpText",
      defaultMessage: "Note: Refresh is disabled while there is an active selection.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 21
      }
    })))] : [])],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
AutoRefreshButtonComponent.displayName = 'AutoRefreshButtonComponent';
const AutoRefreshButton = exports.AutoRefreshButton = /*#__PURE__*/_react.default.memo(AutoRefreshButtonComponent);
AutoRefreshButton.displayName = 'AutoRefreshButton';