"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommonRuleFieldReadOnly = CommonRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _related_integrations = require("./fields/related_integrations/related_integrations");
var _required_fields = require("./fields/required_fields/required_fields");
var _severity_mapping = require("./fields/severity_mapping/severity_mapping");
var _risk_score_mapping = require("./fields/risk_score_mapping/risk_score_mapping");
var _threat = require("./fields/threat/threat");
var _name = require("./fields/name/name");
var _tags = require("./fields/tags/tags");
var _description = require("./fields/description/description");
var _utility_types = require("../../../../../../../common/utility_types");
var _building_block = require("./fields/building_block/building_block");
var _investigation_fields = require("./fields/investigation_fields/investigation_fields");
var _false_positives = require("./fields/false_positives/false_positives");
var _max_signals = require("./fields/max_signals/max_signals");
var _note = require("./fields/note/note");
var _rule_schedule = require("./fields/rule_schedule/rule_schedule");
var _references = require("./fields/references/references");
var _risk_score = require("./fields/risk_score/risk_score");
var _rule_name_override = require("./fields/rule_name_override/rule_name_override");
var _setup = require("./fields/setup/setup");
var _severity = require("./fields/severity/severity");
var _timestamp_override = require("./fields/timestamp_override/timestamp_override");
var _timeline_template = require("./fields/timeline_template/timeline_template");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/common_rule_field_readonly.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line complexity
function CommonRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'building_block':
      return /*#__PURE__*/_react.default.createElement(_building_block.BuildingBlockReadOnly, {
        buildingBlock: finalDiffableRule.building_block,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 14
        }
      });
    case 'description':
      return /*#__PURE__*/_react.default.createElement(_description.DescriptionReadOnly, {
        description: finalDiffableRule.description,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 14
        }
      });
    case 'investigation_fields':
      return /*#__PURE__*/_react.default.createElement(_investigation_fields.InvestigationFieldsReadOnly, {
        investigationFields: finalDiffableRule.investigation_fields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 9
        }
      });
    case 'false_positives':
      return /*#__PURE__*/_react.default.createElement(_false_positives.FalsePositivesReadOnly, {
        falsePositives: finalDiffableRule.false_positives,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 14
        }
      });
    case 'max_signals':
      return /*#__PURE__*/_react.default.createElement(_max_signals.MaxSignalsReadOnly, {
        maxSignals: finalDiffableRule.max_signals,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 14
        }
      });
    case 'name':
      return /*#__PURE__*/_react.default.createElement(_name.NameReadOnly, {
        name: finalDiffableRule.name,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 14
        }
      });
    case 'note':
      return /*#__PURE__*/_react.default.createElement(_note.NoteReadOnly, {
        note: finalDiffableRule.note,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 14
        }
      });
    case 'related_integrations':
      return /*#__PURE__*/_react.default.createElement(_related_integrations.RelatedIntegrationsReadOnly, {
        relatedIntegrations: finalDiffableRule.related_integrations,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      });
    case 'required_fields':
      return /*#__PURE__*/_react.default.createElement(_required_fields.RequiredFieldsReadOnly, {
        requiredFields: finalDiffableRule.required_fields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 14
        }
      });
    case 'risk_score_mapping':
      return /*#__PURE__*/_react.default.createElement(_risk_score_mapping.RiskScoreMappingReadOnly, {
        riskScoreMapping: finalDiffableRule.risk_score_mapping,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 14
        }
      });
    case 'rule_schedule':
      return /*#__PURE__*/_react.default.createElement(_rule_schedule.RuleScheduleReadOnly, {
        ruleSchedule: finalDiffableRule.rule_schedule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 14
        }
      });
    case 'severity_mapping':
      return /*#__PURE__*/_react.default.createElement(_severity_mapping.SeverityMappingReadOnly, {
        severityMapping: finalDiffableRule.severity_mapping,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 14
        }
      });
    case 'tags':
      return /*#__PURE__*/_react.default.createElement(_tags.TagsReadOnly, {
        tags: finalDiffableRule.tags,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 14
        }
      });
    case 'threat':
      return /*#__PURE__*/_react.default.createElement(_threat.ThreatReadOnly, {
        threat: finalDiffableRule.threat,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 14
        }
      });
    case 'references':
      return /*#__PURE__*/_react.default.createElement(_references.ReferencesReadOnly, {
        references: finalDiffableRule.references,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 14
        }
      });
    case 'risk_score':
      return /*#__PURE__*/_react.default.createElement(_risk_score.RiskScoreReadOnly, {
        riskScore: finalDiffableRule.risk_score,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 14
        }
      });
    case 'rule_id':
      /* Rule ID is not displayed in the UI */
      return null;
    case 'rule_name_override':
      return /*#__PURE__*/_react.default.createElement(_rule_name_override.RuleNameOverrideReadOnly, {
        ruleNameOverride: finalDiffableRule.rule_name_override,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 14
        }
      });
    case 'setup':
      return /*#__PURE__*/_react.default.createElement(_setup.SetupReadOnly, {
        setup: finalDiffableRule.setup,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 14
        }
      });
    case 'severity':
      return /*#__PURE__*/_react.default.createElement(_severity.SeverityReadOnly, {
        severity: finalDiffableRule.severity,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 14
        }
      });
    case 'timestamp_override':
      return /*#__PURE__*/_react.default.createElement(_timestamp_override.TimestampOverrideReadOnly, {
        timestampOverride: finalDiffableRule.timestamp_override,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 14
        }
      });
    case 'timeline_template':
      return /*#__PURE__*/_react.default.createElement(_timeline_template.TimelineTemplateReadOnly, {
        timelineTemplate: finalDiffableRule.timeline_template,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 14
        }
      });
    case 'version':
      /* Version is not displayed in the UI */
      return null;
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}