"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_FROM_ELASTIC_TITLE = exports.UPDATE_FROM_ELASTIC_EXPLANATION = exports.TITLE = exports.NO_CHANGES = exports.MY_ORIGINAL_CHANGES_TITLE = exports.MY_ORIGINAL_CHANGES_EXPLANATION = exports.MY_CHANGES_AND_FINAL_UPDATES_TITLE = exports.MY_CHANGES_AND_FINAL_UPDATES_EXPLANATION = exports.MERGED_CHANGES_TITLE = exports.MERGED_CHANGES_EXPLANATION = exports.DIFF_FORMAT_AND_COLORS_EXPLANATION = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../field_final_side/components/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.comparisonSide.title', {
  defaultMessage: 'Diff view'
});
const NO_CHANGES = exports.NO_CHANGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.comparisonSide.noChangesLabel', {
  defaultMessage: 'No changes'
});
const UPDATE_FROM_ELASTIC_TITLE = exports.UPDATE_FROM_ELASTIC_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.updateFromElasticTitle', {
  defaultMessage: 'Changes from Elastic'
});
const UPDATE_FROM_ELASTIC_EXPLANATION = exports.UPDATE_FROM_ELASTIC_EXPLANATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.updateFromElasticExplanation', {
  defaultMessage: "Compare the field's original value with changes from the Elastic update. Your changes aren't displayed."
});
const MY_CHANGES_AND_FINAL_UPDATES_TITLE = exports.MY_CHANGES_AND_FINAL_UPDATES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.myChangesAndFinalUpdatesTitle', {
  defaultMessage: 'My changes and final updates'
});
const MY_CHANGES_AND_FINAL_UPDATES_EXPLANATION = exports.MY_CHANGES_AND_FINAL_UPDATES_EXPLANATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.myChangesAndFinalUpdatesExplanation', {
  defaultMessage: "Compare the field's original value with your changes or changes made in the {finalUpdateSectionLabel} section.",
  values: {
    finalUpdateSectionLabel: _translations.FINAL_UPDATE
  }
});
const MERGED_CHANGES_TITLE = exports.MERGED_CHANGES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.mergedChangesTitle', {
  defaultMessage: "My changes merged with Elastic's"
});
const MERGED_CHANGES_EXPLANATION = exports.MERGED_CHANGES_EXPLANATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.mergedChangesExplanation', {
  defaultMessage: "Compare the field's original value with a version that combines your changes with those in the Elastic update. This version is only a suggestion."
});
const MY_ORIGINAL_CHANGES_TITLE = exports.MY_ORIGINAL_CHANGES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.myOriginalChangesTitle', {
  defaultMessage: 'My changes only'
});
const MY_ORIGINAL_CHANGES_EXPLANATION = exports.MY_ORIGINAL_CHANGES_EXPLANATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.myOriginalChangesExplanation', {
  defaultMessage: "Compare the field's original value with your changes. Modifications in the {finalUpdateSectionLabel} section aren't displayed.",
  values: {
    finalUpdateSectionLabel: _translations.FINAL_UPDATE
  }
});
const DIFF_FORMAT_AND_COLORS_EXPLANATION = exports.DIFF_FORMAT_AND_COLORS_EXPLANATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.versions.diffFormatAndColorsExplanation', {
  defaultMessage: "Differences are shown in JSON and color-coded or bolded. Lines that are highlighted in green were added. Lines that are highlighted in red were removed. Text that's bolded was changed."
});