"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDiffTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _eui = require("@elastic/eui");
var _utils = require("../../../../../common/detection_engine/utils");
var _helpers = require("../../../rule_creation_ui/pages/rule_creation/helpers");
var _diff_view = require("./json_diff/diff_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_diff_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* Inclding these properties in diff display might be confusing to users. */
const HIDDEN_PROPERTIES = [
/*
  By default, prebuilt rules don't have any actions or exception lists. So if a user has defined actions or exception lists for a rule, it'll show up as diff. This looks confusing as the user might think that their actions and exceptions lists will get removed after the upgrade, which is not the case - they will be preserved.
*/
'actions', 'exceptions_list',
/*
  Most prebuilt rules are installed as "disabled". Once user enables a rule, it'll show as diff, which doesn't add value.
*/
'enabled', /* Technical property. Hidden because it can be confused with "version" by users. */
'revision',
/*
  "updated_at" value is regenerated on every '/upgrade/_review' endpoint run
  and will therefore always show a diff. It adds no value to display it to the user.
*/
'updated_at',
/*
  These values make sense only for installed prebuilt rules.
  They are not present in the prebuilt rule package.
  So, showing them in the diff doesn't add value.
*/
'updated_by', 'created_at', 'created_by',
/*
 * Another technical property that is used for logic under the hood the user doesn't need to be aware of
 */
'rule_source', /* Technical property that changes at rule runtime. */
'execution_summary'];
const sortAndStringifyJson = jsObject => (0, _jsonStableStringify.default)(jsObject, {
  space: 2
});

/**
 * Normalizes the rule object, making it suitable for comparison with another normalized rule.
 *
 * Normalization is needed to avoid showing diffs for semantically equal property values.
 * Saving a rule via the rule editing UI might change the format of some properties or set default values.
 * This function compensates for those changes.
 *
 * @param {RuleResponse} originalRule - Rule of a RuleResponse type.
 * @returns {RuleResponse} - The updated normalized rule object.
 */
const normalizeRule = originalRule => {
  var _rule$note;
  const rule = {
    ...originalRule
  };

  /*
    Default "note" to an empty string if it's not present.
    Sometimes, in a new version of a rule, the "note" value equals an empty string, while
    in the old version, it wasn't specified at all (undefined becomes ''). In this case,
    it doesn't make sense to show diff, so we default falsy values to ''.
  */
  rule.note = (_rule$note = rule.note) !== null && _rule$note !== void 0 ? _rule$note : '';

  /*
    Removes empty arrays (techniques, subtechniques) from the MITRE ATT&CK value.
    The same processing is done in the rule editing UI before submitting the edits.
  */
  rule.threat = (0, _helpers.filterEmptyThreats)(rule.threat);

  /*
    The "machine_learning_job_id" property is converted from the legacy string format
    to the new array format during installation and upgrade. Thus, all installed rules
    use the new format. For correct comparison, we must ensure that the rule update is
    also in the new format before showing the diff.
  */
  if ('machine_learning_job_id' in rule) {
    rule.machine_learning_job_id = (0, _utils.normalizeMachineLearningJobIds)(rule.machine_learning_job_id);
  }

  /*
    Default the "alias" property to null for all threat filters that don't have it.
    Setting a default is needed to match the behavior of the rule editing UI,
    which also defaults the "alias" property to null.
  */
  if (rule.type === 'threat_match' && Array.isArray(rule.threat_filters)) {
    const threatFiltersWithDefaultMeta = rule.threat_filters.map(filter => {
      if (!filter.meta.alias) {
        return {
          ...filter,
          meta: {
            ...filter.meta,
            alias: null
          }
        };
      }
      return filter;
    });
    rule.threat_filters = threatFiltersWithDefaultMeta;
  }
  return rule;
};
const RuleDiffTab = ({
  oldRule,
  newRule,
  leftDiffSideLabel,
  rightDiffSideLabel,
  leftDiffSideDescription,
  rightDiffSideDescription
}) => {
  const [oldSource, newSource] = (0, _react.useMemo)(() => {
    const visibleNewRuleProperties = (0, _lodash.omit)(normalizeRule(newRule), ...HIDDEN_PROPERTIES);
    const visibleOldRuleProperties = (0, _lodash.omit)(/* Only compare properties that are present in the update. */
    (0, _lodash.pick)(normalizeRule(oldRule), Object.keys(visibleNewRuleProperties)));
    return [sortAndStringifyJson(visibleOldRuleProperties), sortAndStringifyJson(visibleNewRuleProperties)];
  }, [oldRule, newRule]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: leftDiffSideDescription,
    type: "info",
    size: "m",
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, leftDiffSideLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    color: "subdued",
    content: rightDiffSideDescription,
    type: "info",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, rightDiffSideLabel)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    size: "full",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_diff_view.DiffView, {
    oldSource: oldSource,
    newSource: newSource,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  })));
};
exports.RuleDiffTab = RuleDiffTab;