"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleCustomizationsFlyout = exports.RULE_CUSTOMIZATIONS_DIFF_FLYOUT_ANCHOR = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _per_field_rule_diff_tab = require("../per_field_rule_diff_tab");
var _rule_details_flyout = require("../rule_details_flyout");
var ruleDetailsI18n = _interopRequireWildcard(require("../translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_diff_tab = require("../rule_diff_tab");
var _rule_customizations_flyout_subheader = require("./rule_customizations_flyout_subheader");
var _use_revert_prebuilt_rule = require("../../../logic/prebuilt_rules/use_revert_prebuilt_rule");
var _rule_field_diff = require("../../../model/rule_details/rule_field_diff");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_customizations_diff/rule_customizations_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULE_CUSTOMIZATIONS_DIFF_FLYOUT_ANCHOR = exports.RULE_CUSTOMIZATIONS_DIFF_FLYOUT_ANCHOR = 'ruleCustomizationsDiffFlyout';
const RuleCustomizationsFlyout = exports.RuleCustomizationsFlyout = /*#__PURE__*/(0, _react.memo)(function RuleCustomizationsFlyout({
  currentRule,
  baseRule,
  diff,
  closeFlyout,
  isReverting
}) {
  const isOutdated = useConcurrencyControl(currentRule);
  const {
    mutateAsync: revertPrebuiltRule,
    isLoading
  } = (0, _use_revert_prebuilt_rule.useRevertPrebuiltRule)();
  const subHeader = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_rule_customizations_flyout_subheader.RuleCustomizationsFlyoutSubheader, {
    currentRule: currentRule,
    diff: diff,
    isOutdated: isOutdated,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), [currentRule, diff, isOutdated]);
  const revertRule = (0, _react.useCallback)(async () => {
    try {
      await revertPrebuiltRule({
        id: currentRule.id,
        version: currentRule.version,
        revision: currentRule.revision
      });
      closeFlyout();
    } catch (error) {
      const statusCode = (0, _use_revert_prebuilt_rule.getRevertRuleErrorStatusCode)(error);
      // Don't close flyout on concurrency errors
      if (statusCode !== 409) {
        closeFlyout();
      }
    }
  }, [closeFlyout, currentRule.id, currentRule.revision, currentRule.version, revertPrebuiltRule]);
  const ruleActions = (0, _react.useMemo)(() => {
    return isReverting ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: revertRule,
      isDisabled: isLoading || isOutdated,
      fill: true,
      "data-test-subj": "revertPrebuiltRuleFromFlyoutButton",
      iconType: "arrowStart",
      iconSide: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, i18n.REVERT_BUTTON_LABEL) : null;
  }, [isLoading, isOutdated, isReverting, revertRule]);
  const extraTabs = (0, _react.useMemo)(() => {
    const headerCallout = isReverting ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      title: i18n.REVERTING_RULE_CALLOUT_TITLE,
      color: "warning",
      iconType: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, i18n.REVERTING_RULE_CALLOUT_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 9
      }
    })) : null;
    const updatesTab = {
      id: 'updates',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: i18n.RULE_CUSTOMIZATIONS_FLYOUT_UPDATES_TAB_TOOLTIP,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 11
        }
      }, i18n.RULE_CUSTOMIZATIONS_FLYOUT_UPDATES_TAB_TITLE)),
      content: /*#__PURE__*/_react.default.createElement(_rule_details_flyout.TabContentPadding, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_per_field_rule_diff_tab.PerFieldRuleDiffTab, {
        header: headerCallout,
        ruleDiff: diff,
        leftDiffSideLabel: i18n.BASE_VERSION_LABEL,
        rightDiffSideLabel: i18n.CURRENT_VERSION_LABEL,
        leftDiffSideDescription: i18n.BASE_VERSION_DESCRIPTION,
        rightDiffSideDescription: i18n.CURRENT_VERSION_DESCRIPTION,
        diffLayout: _rule_field_diff.DiffLayout.RightToLeft,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 11
        }
      }))
    };
    const jsonViewTab = {
      id: 'jsonViewUpdates',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: i18n.RULE_CUSTOMIZATIONS_FLYOUT_JSON_TAB_TOOLTIP,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 11
        }
      }, ruleDetailsI18n.JSON_VIEW_UPDATES_TAB_LABEL)),
      content: /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_diff_tab.RuleDiffTab, {
        oldRule: baseRule,
        newRule: currentRule,
        leftDiffSideLabel: i18n.BASE_VERSION_LABEL,
        rightDiffSideLabel: i18n.CURRENT_VERSION_LABEL,
        leftDiffSideDescription: i18n.BASE_VERSION_DESCRIPTION,
        rightDiffSideDescription: i18n.CURRENT_VERSION_DESCRIPTION,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }))
    };
    return [updatesTab, jsonViewTab];
    /**
     * We want to statically load this data so it doesn't change while user is viewing so
     * we don't rerender the diff displays based on `currentRule`, `baseRule`, or `diff`.
     * User is alerted to stale data when present via the `isOutdated` prop
     */
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isReverting]);
  return /*#__PURE__*/_react.default.createElement(_rule_details_flyout.RuleDetailsFlyout, {
    title: i18n.BASE_VERSION_FLYOUT_TITLE,
    rule: currentRule,
    size: "l",
    id: RULE_CUSTOMIZATIONS_DIFF_FLYOUT_ANCHOR,
    dataTestSubj: RULE_CUSTOMIZATIONS_DIFF_FLYOUT_ANCHOR,
    closeFlyout: closeFlyout,
    ruleActions: ruleActions,
    extraTabs: extraTabs,
    subHeader: subHeader,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  });
});

/**
 * We should detect situations when the rule is edited or upgraded concurrently.
 *
 * `revision` is the indication for any changes.
 * If `rule.revision` has suddenly increased then it means we hit a concurrency issue.
 *
 * `rule.revision` gets bumped upon rule upgrade as well.
 */
function useConcurrencyControl(rule) {
  const concurrencyControl = (0, _react.useRef)();
  const [isOutdated, setIsOutdated] = (0, _react.useState)(false);
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  (0, _react.useEffect)(() => {
    const concurrency = concurrencyControl.current;
    if (concurrency != null && concurrency.revision !== rule.revision) {
      addWarning({
        title: i18n.NEW_REVISION_DETECTED_WARNING,
        text: i18n.NEW_REVISION_DETECTED_WARNING_MESSAGE
      });
      setIsOutdated(true);
    }
    concurrencyControl.current = {
      revision: rule.revision
    };
  }, [addWarning, rule.revision]);
  return isOutdated;
}