"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModifiedRuleBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _detection_engine = require("../../../../../common/api/detection_engine");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_customizations_context = require("./rule_customizations_diff/rule_customizations_context");
var _prebuilt_rule_diff_badge = require("./prebuilt_rule_diff_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/modified_rule_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ModifiedRuleBadge = ({
  rule
}) => {
  const {
    state: {
      doesBaseVersionExist
    }
  } = (0, _rule_customizations_context.useRuleCustomizationsContext)();
  const toolTipTitle = (0, _react.useMemo)(() => doesBaseVersionExist ? i18n.MODIFIED_PREBUILT_DIFF_TOOLTIP_TITLE : i18n.NO_BASE_VERSION_MODIFIED_PREBUILT_DIFF_TOOLTIP_TITLE, [doesBaseVersionExist]);
  const toolTipContent = (0, _react.useMemo)(() => doesBaseVersionExist ? i18n.MODIFIED_PREBUILT_DIFF_TOOLTIP_CONTENT : i18n.NO_BASE_VERSION_MODIFIED_PREBUILT_DIFF_TOOLTIP_CONTENT, [doesBaseVersionExist]);
  if (rule === null || !(0, _detection_engine.isCustomizedPrebuiltRule)(rule)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    title: toolTipTitle,
    content: toolTipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, doesBaseVersionExist ? /*#__PURE__*/_react.default.createElement(_prebuilt_rule_diff_badge.PrebuiltRuleDiffBadge, {
    label: i18n.MODIFIED_PREBUILT_RULE_LABEL,
    dataTestSubj: "modified-prebuilt-rule-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "modified-prebuilt-rule-badge-no-base-version",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, i18n.MODIFIED_PREBUILT_RULE_LABEL));
};
exports.ModifiedRuleBadge = ModifiedRuleBadge;