"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSharedListsTableColumns = exports.getRulesTableColumn = exports.enrichNewExceptionItems = exports.enrichItemsForSharedLists = exports.enrichItemsForDefaultRuleList = exports.enrichItemWithName = exports.enrichItemWithExpireTime = exports.enrichItemWithComment = exports.enrichExceptionItemsForUpdate = exports.enrichEndpointItems = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _eui = require("@elastic/eui");
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _popover_items = require("../../../../common/components/popover_items");
var _helpers = require("../../utils/helpers");
var _components = require("../../../../exceptions/components");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Adds user defined name to all new exceptionItems
 * @param commentToAdd new comment to add to item
 */
const enrichItemWithComment = commentToAdd => items => {
  return commentToAdd.trim() !== '' ? (0, _helpers.enrichNewExceptionItemsWithComments)(items, [{
    comment: commentToAdd
  }]) : items;
};

/**
 * Adds user defined name to all new exceptionItems
 * @param itemName exception item name
 */
exports.enrichItemWithComment = enrichItemWithComment;
const enrichItemWithName = itemName => items => {
  return itemName.trim() !== '' ? (0, _helpers.enrichNewExceptionItemsWithName)(items, itemName) : items;
};

/**
 * Adds expiration datetime to all new exceptionItems
 * @param expireTimeToAdd new expireTime to add to item
 */
exports.enrichItemWithName = enrichItemWithName;
const enrichItemWithExpireTime = expireTimeToAdd => items => (0, _helpers.enrichNewExceptionItemsWithExpireTime)(items, expireTimeToAdd);

/**
 * Modifies item entries to be in correct format and adds os selection to items
 * @param listType exception list type
 * @param selectedOs os selection
 */
exports.enrichItemWithExpireTime = enrichItemWithExpireTime;
const enrichEndpointItems = (listType, selectedOs) => items => {
  if (listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.lowercaseHashValues)((0, _helpers.enrichExceptionItemsWithOS)(items, selectedOs));
  } else {
    return items;
  }
};

/**
 * Modifies exception items to prepare for creating as rule_default
 * list items
 * @param listType exception list type
 * @param addToRules boolean determining if user selected to add items to default rule list
 */
exports.enrichEndpointItems = enrichEndpointItems;
const enrichItemsForDefaultRuleList = (listType, addToRules) => items => {
  if (addToRules && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.enrichRuleExceptions)(items);
  } else {
    return items;
  }
};

/**
 * Prepares items to be added to shared exception lists
 * @param listType exception list type
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param lists shared exception lists that were selected to add items to
 */
exports.enrichItemsForDefaultRuleList = enrichItemsForDefaultRuleList;
const enrichItemsForSharedLists = (listType, addToSharedLists, lists) => items => {
  if (addToSharedLists && listType !== _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT) {
    return (0, _helpers.enrichSharedExceptions)(items, lists);
  } else {
    return items;
  }
};

/**
 * Series of utils to modify and prepare exception items for update or creation
 * @param itemName user defined exception item name
 * @param commentToAdd comment to be added to item
 * @param addToRules boolean determining if user selected to add items to default rule list
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param sharedLists shared exception lists that were selected to add items to
 * @param selectedOs os selection
 * @param listType exception list type
 * @param expireTime exception item expire time
 * @param items exception items to be modified
 */
exports.enrichItemsForSharedLists = enrichItemsForSharedLists;
const enrichNewExceptionItems = ({
  itemName,
  commentToAdd,
  addToRules,
  addToSharedLists,
  sharedLists,
  selectedOs,
  listType,
  expireTime,
  items
}) => {
  const enriched = (0, _fp.pipe)(enrichItemWithComment(commentToAdd), enrichItemWithExpireTime(expireTime), enrichItemWithName(itemName), enrichEndpointItems(listType, selectedOs), enrichItemsForDefaultRuleList(listType, addToRules), enrichItemsForSharedLists(listType, addToSharedLists, sharedLists))(items);
  return enriched;
};

/**
 * Series of utils to modify and prepare exception items for update or creation
 * @param itemName user defined exception item name
 * @param commentToAdd comment to be added to item
 * @param addToRules boolean determining if user selected to add items to default rule list
 * @param addToSharedLists boolean determining if user selected to add items to shared list
 * @param sharedLists shared exception lists that were selected to add items to
 * @param selectedOs os selection
 * @param listType exception list type
 * @param expireTime exception item expire time
 * @param items exception items to be modified
 */
exports.enrichNewExceptionItems = enrichNewExceptionItems;
const enrichExceptionItemsForUpdate = ({
  itemName,
  commentToAdd,
  selectedOs,
  listType,
  expireTime,
  items
}) => {
  const enriched = (0, _fp.pipe)(enrichItemWithComment(commentToAdd), enrichItemWithExpireTime(expireTime), enrichItemWithName(itemName), enrichEndpointItems(listType, selectedOs))(items);
  return enriched;
};

/**
 * Shared lists columns for EuiInMemoryTable
 */
exports.enrichExceptionItemsForUpdate = enrichExceptionItemsForUpdate;
const getSharedListsTableColumns = () => [{
  field: 'name',
  name: i18n.NAME_COLUMN,
  sortable: true,
  'data-test-subj': 'exceptionListNameCell'
}, {
  field: 'referenced_rules',
  name: 'Number of rules linked to',
  sortable: false,
  'data-test-subj': 'exceptionListRulesLinkedToIdCell',
  render: references => /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.HeaderMenu, {
    emptyButton: true,
    useCustomActions: true,
    actions: (0, _securitysolutionExceptionListComponents.generateLinkedRulesMenuItems)({
      dataTestSubj: 'addToSharedListsLinkedRulesMenu',
      linkedRules: references,
      securityLinkAnchorComponent: _components.LinkToRuleDetails
    }),
    panelPaddingSize: "none",
    disableActions: false,
    text: references.length.toString(),
    dataTestSubj: "addToSharedListsLinkedRulesMenuAction",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  })
}, {
  name: i18n.ACTION_COLUMN,
  'data-test-subj': 'exceptionListRulesActionCell',
  render: list => {
    return /*#__PURE__*/_react.default.createElement(_components.LinkToListDetails, {
      dataTestSubj: "exceptionListActionCell-link",
      linkTitle: i18n.VIEW_LIST_DETAIL_ACTION,
      listId: list.list_id,
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    });
  }
}];

/**
 * Rules columns for EuiInMemoryTable
 */
exports.getSharedListsTableColumns = getSharedListsTableColumns;
const getRulesTableColumn = () => [{
  field: 'name',
  align: 'left',
  name: i18n.NAME_COLUMN,
  sortable: true,
  'data-test-subj': 'ruleNameCell',
  truncateText: false
}, {
  field: 'tags',
  align: 'left',
  name: i18n.TAGS_COLUMN,
  'data-test-subj': 'ruleNameCell',
  render: tags => {
    if (tags.length === 0) {
      return null;
    }
    const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      key: `${tag}-${i}`,
      "data-test-subj": "tag",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    }, tag);
    return /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
      items: tags,
      popoverTitle: i18n.TAGS_COLUMN,
      popoverButtonTitle: tags.length.toString(),
      popoverButtonIcon: "tag",
      dataTestPrefix: "tags",
      renderItem: renderItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 9
      }
    });
  }
}, {
  name: i18n.ACTION_COLUMN,
  'data-test-subj': 'ruleAction-view',
  render: rule => {
    return /*#__PURE__*/_react.default.createElement(_components.LinkToRuleDetails, {
      external: true,
      referenceId: rule.id,
      referenceName: i18n.VIEW_RULE_DETAIL_ACTION,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 9
      }
    });
  }
}];
exports.getRulesTableColumn = getRulesTableColumn;