"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionFlyoutFooter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/footer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutFooterGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  ${({
  theme
}) => (0, _styledComponents.css)`
    padding: ${theme.eui.euiSizeS};
  `}
`;
const ExceptionFlyoutFooter = exports.ExceptionFlyoutFooter = /*#__PURE__*/(0, _react.memo)(function ExceptionFlyoutFooter({
  isEdit = false,
  listType,
  isSubmitButtonDisabled,
  cancelButtonDataTestSubjId,
  submitButtonDataTestSubjId,
  handleOnSubmit,
  handleCloseFlyout
}) {
  const addButtonMessage = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.ADD_ENDPOINT_EXCEPTION : i18n.CREATE_RULE_EXCEPTION;
  }, [listType]);
  const editButtonMessage = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EDIT_ENDPOINT_EXCEPTION_TITLE : i18n.EDIT_EXCEPTION_TITLE;
  }, [listType]);
  const submitButtonMessage = isEdit ? editButtonMessage : addButtonMessage;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutFooterGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": cancelButtonDataTestSubjId,
    onClick: handleCloseFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, i18n.CANCEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": submitButtonDataTestSubjId,
    onClick: handleOnSubmit,
    isDisabled: isSubmitButtonDisabled,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, submitButtonMessage)));
});