"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemsFlyoutAlertsActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
var _use_signal_index = require("../../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _source = require("../../../../../common/containers/source");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/alerts_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutCheckboxesSection = _styledComponents.default.section`
  overflow-y: inherit;
  height: auto;
  .euiFlyoutBody__overflowContent {
    padding-top: 0;
  }
`;
const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionItemsFlyoutAlertsActionsComponent = ({
  isAlertDataLoading,
  exceptionListItems,
  exceptionListType,
  shouldCloseSingleAlert,
  shouldBulkCloseAlert,
  disableBulkClose,
  alertData,
  alertStatus,
  onDisableBulkClose,
  onUpdateBulkCloseIndex,
  onBulkCloseCheckboxChange,
  onSingleAlertCloseCheckboxChange
}) => {
  const {
    loading: isSignalIndexLoading,
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const memoSignalIndexName = (0, _react.useMemo)(() => signalIndexName !== null ? [signalIndexName] : [], [signalIndexName]);
  const [isSignalIndexPatternLoading, {
    indexPatterns: signalIndexPatterns
  }] = (0, _source.useFetchIndex)(memoSignalIndexName);
  const handleBulkCloseCheckbox = (0, _react.useCallback)(event => {
    onBulkCloseCheckboxChange(event.currentTarget.checked);
  }, [onBulkCloseCheckboxChange]);
  const handleCloseSingleAlertCheckbox = (0, _react.useCallback)(event => {
    if (onSingleAlertCloseCheckboxChange != null) {
      onSingleAlertCloseCheckboxChange(event.currentTarget.checked);
    }
  }, [onSingleAlertCloseCheckboxChange]);
  (0, _react.useEffect)(() => {
    onUpdateBulkCloseIndex(shouldBulkCloseAlert && memoSignalIndexName != null ? memoSignalIndexName : undefined);
  }, [memoSignalIndexName, onUpdateBulkCloseIndex, shouldBulkCloseAlert]);
  (0, _react.useEffect)(() => {
    if (disableBulkClose === true) {
      onBulkCloseCheckboxChange(false);
    }
  }, [disableBulkClose, onBulkCloseCheckboxChange]);
  (0, _react.useEffect)(() => {
    if (isSignalIndexPatternLoading === false && isSignalIndexLoading === false) {
      onDisableBulkClose((0, _utils.shouldDisableBulkClose)({
        items: exceptionListItems,
        signalIndexPatterns
      }));
    }
  }, [onDisableBulkClose, exceptionListItems, isSignalIndexPatternLoading, isSignalIndexLoading, signalIndexPatterns]);
  return /*#__PURE__*/_react.default.createElement(FlyoutCheckboxesSection, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, i18n.CLOSE_ALERTS_SECTION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), alertData != null && alertStatus !== 'closed' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "closeAlertOnAddExceptionCheckbox",
    id: "close-alert-on-add-add-exception-checkbox",
    label: i18n.SINGLE_ALERT_CLOSE_LABEL,
    checked: shouldCloseSingleAlert,
    onChange: handleCloseSingleAlertCheckbox,
    disabled: isSignalIndexLoading || isSignalIndexPatternLoading || isAlertDataLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "bulkCloseAlertOnAddExceptionCheckbox",
    id: "bulk-close-alert-on-add-add-exception-checkbox",
    label: disableBulkClose ? i18n.BULK_CLOSE_LABEL_DISABLED : i18n.BULK_CLOSE_LABEL,
    checked: shouldBulkCloseAlert,
    onChange: handleBulkCloseCheckbox,
    disabled: disableBulkClose || isSignalIndexLoading || isSignalIndexPatternLoading || isAlertDataLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  })), exceptionListType === 'endpoint' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "addExceptionEndpointText",
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, i18n.ENDPOINT_QUARANTINE_TEXT)));
};
const ExceptionItemsFlyoutAlertsActions = exports.ExceptionItemsFlyoutAlertsActions = /*#__PURE__*/_react.default.memo(ExceptionItemsFlyoutAlertsActionsComponent);
ExceptionItemsFlyoutAlertsActions.displayName = 'ExceptionItemsFlyoutAlertsActions';