"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedDuration = exports.RuleDurationFormat = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/execution_log_table/rule_duration_format.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFormattedDuration = value => {
  if (!value) {
    return '00:00:00:000';
  }
  const duration = _moment.default.duration(value);
  const days = Math.floor(duration.asDays()).toString().padStart(3, '0');
  const hours = Math.floor(duration.asHours() % 24).toString().padStart(2, '0');
  const minutes = Math.floor(duration.asMinutes() % 60).toString().padStart(2, '0');
  const seconds = duration.seconds().toString().padStart(2, '0');
  const ms = duration.milliseconds().toString().padStart(3, '0');
  if (Math.floor(duration.asDays()) > 0) {
    if (Math.floor(duration.asDays()) >= 365) {
      return i18n.GREATER_THAN_YEAR;
    } else {
      return `${days}:${hours}:${minutes}:${seconds}:${ms}`;
    }
  } else {
    return `${hours}:${minutes}:${seconds}:${ms}`;
  }
};

/**
 * Formats duration as (hh:mm:ss:SSS) by default, overflowing to include days
 * as (ddd:hh:mm:ss:SSS) if necessary, and then finally to `> 1 Year`
 * @param props duration as millis, set isSeconds:true to pass in seconds
 * @constructor
 */
exports.getFormattedDuration = getFormattedDuration;
const RuleDurationFormatComponent = props => {
  const {
    duration,
    isSeconds = false,
    allowZero = true
  } = props;
  const formattedDuration = (0, _react.useMemo)(() => {
    // Durations can be buggy and return negative
    if (allowZero && duration >= 0) {
      return getFormattedDuration(isSeconds ? duration * 1000 : duration);
    }
    return i18n.DURATION_NOT_AVAILABLE;
  }, [allowZero, duration, isSeconds]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "rule-duration-format-value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 10
    }
  }, formattedDuration);
};
const RuleDurationFormat = exports.RuleDurationFormat = /*#__PURE__*/_react.default.memo(RuleDurationFormatComponent);
RuleDurationFormat.displayName = 'RuleDurationFormat';