"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleIndexPattern = exports.useRuleForms = void 0;
var _react = require("react");
var _use_form_with_warnings = require("../../../common/hooks/use_form_with_warnings");
var _types = require("../../common/types");
var _kibana = require("../../../common/lib/kibana");
var _shared_imports = require("../../../shared_imports");
var _schema = require("../components/step_define_rule/schema");
var _schema2 = require("../components/step_about_rule/schema");
var _schema3 = require("../components/step_schedule_rule/schema");
var _get_schema = require("../../rule_creation/components/step_rule_actions/get_schema");
var _source = require("../../../common/containers/source");
var _use_connectors = require("../../../common/hooks/use_connectors");
var _validation_warning_codes = require("../../rule_creation/constants/validation_warning_codes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRuleForms = ({
  defineStepDefault,
  aboutStepDefault,
  scheduleStepDefault,
  actionsStepDefault
}) => {
  const {
    triggersActionsUi: {
      actionTypeRegistry
    },
    http
  } = (0, _kibana.useKibana)().services;
  const {
    connectors,
    setCurrentConnector
  } = (0, _use_connectors.useConnectors)({
    http
  });

  // DEFINE STEP FORM
  const {
    form: defineStepForm
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: defineStepDefault,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema: _schema.schema
  });
  const [defineStepFormData] = (0, _shared_imports.useFormData)({
    form: defineStepForm
  });
  // FormData doesn't populate on the first render, so we use the defaultValue if the formData
  // doesn't have what we wanted
  const defineStepData = (0, _react.useMemo)(() => 'index' in defineStepFormData ? defineStepFormData : defineStepDefault, [defineStepDefault, defineStepFormData]);

  // ABOUT STEP FORM
  const {
    form: aboutStepForm
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: aboutStepDefault,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema: _schema2.schema
  });
  const [aboutStepFormData] = (0, _shared_imports.useFormData)({
    form: aboutStepForm
  });
  const aboutStepData = 'name' in aboutStepFormData ? aboutStepFormData : aboutStepDefault;

  // SCHEDULE STEP FORM
  const {
    form: scheduleStepForm
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: scheduleStepDefault,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema: _schema3.schema
  });
  const [scheduleStepFormData] = (0, _shared_imports.useFormData)({
    form: scheduleStepForm
  });
  const scheduleStepData = 'interval' in scheduleStepFormData ? scheduleStepFormData : scheduleStepDefault;

  // ACTIONS STEP FORM
  const handleNewConnectorCreated = (0, _react.useCallback)(connector => {
    setCurrentConnector(connector);
  }, [setCurrentConnector]);
  const schema = (0, _react.useMemo)(() => (0, _get_schema.getSchema)({
    actionTypeRegistry,
    connectors
  }), [actionTypeRegistry, connectors]);
  const {
    form: actionsStepForm
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: actionsStepDefault,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema
  });
  const [actionsStepFormData] = (0, _shared_imports.useFormData)({
    form: actionsStepForm
  });
  const actionsStepData = 'actions' in actionsStepFormData ? actionsStepFormData : actionsStepDefault;
  return {
    defineStepForm,
    defineStepData,
    aboutStepForm,
    aboutStepData,
    scheduleStepForm,
    scheduleStepData,
    actionsStepForm,
    actionsStepData,
    handleNewConnectorCreated
  };
};
exports.useRuleForms = useRuleForms;
const useRuleIndexPattern = ({
  dataSourceType,
  index,
  dataViewId
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const [isIndexPatternLoading, {
    browserFields,
    indexPatterns: initIndexPattern
  }] = (0, _source.useFetchIndex)(index);
  const [indexPattern, setIndexPattern] = (0, _react.useState)(initIndexPattern);
  // Why do we need this? to ensure the query bar auto-suggest gets the latest updates
  // when the index pattern changes
  // when we select new dataView
  // when we choose some other dataSourceType
  (0, _react.useEffect)(() => {
    if (dataSourceType === _types.DataSourceType.IndexPatterns && !isIndexPatternLoading) {
      setIndexPattern(initIndexPattern);
    }
    if (dataSourceType === _types.DataSourceType.DataView) {
      const fetchDataView = async () => {
        if (dataViewId != null && dataViewId !== '') {
          const dv = await data.dataViews.get(dataViewId);
          setIndexPattern(dv);
        }
      };
      fetchDataView();
    }
  }, [dataSourceType, isIndexPatternLoading, data, dataViewId, initIndexPattern]);
  return {
    indexPattern,
    isIndexPatternLoading,
    browserFields
  };
};
exports.useRuleIndexPattern = useRuleIndexPattern;