"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequiredFieldRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _name_combobox = require("./name_combobox");
var _type_combobox = require("./type_combobox");
var _make_validate_required_field = require("./make_validate_required_field");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/required_fields/required_fields_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RequiredFieldRow = ({
  item,
  removeItem,
  typesByFieldName,
  availableFieldNames,
  getWarnings,
  parentFieldPath
}) => {
  const handleRemove = (0, _react.useCallback)(() => removeItem(item.id), [removeItem, item.id]);
  const rowFieldConfig = (0, _react.useMemo)(() => ({
    validations: [{
      validator: (0, _make_validate_required_field.makeValidateRequiredField)(parentFieldPath)
    }],
    defaultValue: {
      name: '',
      type: ''
    }
  }), [parentFieldPath]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    key: item.id,
    path: item.path,
    config: rowFieldConfig,
    component: RequiredFieldField,
    readDefaultValueOnForm: !item.isNew,
    componentProps: {
      itemId: item.id,
      onRemove: handleRemove,
      typesByFieldName,
      getWarnings
    },
    availableFieldNames: availableFieldNames,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  });
};
exports.RequiredFieldRow = RequiredFieldRow;
const RequiredFieldField = ({
  field,
  typesByFieldName,
  onRemove,
  availableFieldNames,
  getWarnings,
  itemId
}) => {
  const {
    nameWarning,
    typeWarning
  } = getWarnings(field.value);
  const warningMessage = nameWarning || typeWarning;
  const [nameError, typeError] = (0, _react.useMemo)(() => {
    return [field.errors.find(error => 'path' in error && error.path === `${field.path}.name`), field.errors.find(error => 'path' in error && error.path === `${field.path}.type`)];
  }, [field.path, field.errors]);
  const hasError = Boolean(nameError) || Boolean(typeError);
  const errorMessage = (nameError === null || nameError === void 0 ? void 0 : nameError.message) || (typeError === null || typeError === void 0 ? void 0 : typeError.message);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: hasError,
    error: errorMessage,
    helpText: warningMessage && !hasError ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "warning",
      id: `warningText-${itemId}`,
      "data-test-subj": `${field.value.name}-warningText`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, warningMessage) : '',
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_name_combobox.NameComboBox, {
    field: field,
    itemId: itemId,
    availableFieldNames: availableFieldNames,
    typesByFieldName: typesByFieldName,
    nameWarning: nameWarning,
    nameError: nameError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_type_combobox.TypeComboBox, {
    field: field,
    itemId: itemId,
    typesByFieldName: typesByFieldName,
    typeWarning: typeWarning,
    typeError: typeError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: onRemove,
    "aria-label": i18n.REMOVE_REQUIRED_FIELD_BUTTON_ARIA_LABEL,
    "data-test-subj": `removeRequiredFieldButton-${field.value.name}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }))));
};