"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = void 0;
var _react = require("react");
var _public = require("@kbn/data-views-plugin/public");
var _reactRedux = require("react-redux");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../constants");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _selectors = require("../redux/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_DV = new _public.DataView({
  fieldFormats: {}
});
/*
 * This hook should be used whenever we need the actual DataView and not just the spec for the
 * selected data view.
 */
const useDataView = (dataViewManagerScope = _constants.PageScope.default) => {
  const {
    services: {
      dataViews,
      notifications
    }
  } = (0, _kibana.useKibana)();
  const {
    dataViewId,
    status: internalStatus
  } = (0, _reactRedux.useSelector)((0, _selectors.sourcererAdapterSelector)(dataViewManagerScope));
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const [localStatus, setLocalStatus] = (0, _react.useState)('pristine');
  const [retrievedDataView, setRetrievedDataView] = (0, _react.useState)(INITIAL_DV);
  const loadedForTheFirstTimeRef = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    (async () => {
      if (!newDataViewPickerEnabled) {
        return;
      }
      if (!dataViewId || internalStatus !== 'ready') {
        return;
      }
      if (loadedForTheFirstTimeRef.current) {
        setLocalStatus('loading');
      }
      try {
        // TODO: remove conditional .get call when new data view picker is stabilized
        // this is due to the fact that many of our tests mock kibana hook and do not provide proper
        // double for dataViews service
        const currDv = await (dataViews === null || dataViews === void 0 ? void 0 : dataViews.get(dataViewId));
        if (!loadedForTheFirstTimeRef.current) {
          loadedForTheFirstTimeRef.current = true;
        }
        setRetrievedDataView(currDv);
        setLocalStatus('ready');
      } catch (error) {
        var _notifications$toasts, _error$message;
        // TODO: (remove conditional call when feature flag is on (mocks are broken for some tests))
        notifications === null || notifications === void 0 ? void 0 : (_notifications$toasts = notifications.toasts) === null || _notifications$toasts === void 0 ? void 0 : _notifications$toasts.addDanger({
          title: 'Error retrieving data view',
          text: `Error: ${(_error$message = error === null || error === void 0 ? void 0 : error.message) !== null && _error$message !== void 0 ? _error$message : 'unknown'}`
        });
        setLocalStatus('error');
      }
    })();
  }, [dataViews, dataViewId, internalStatus, notifications, newDataViewPickerEnabled]);
  return (0, _react.useMemo)(() => {
    if (!newDataViewPickerEnabled) {
      return {
        dataView: retrievedDataView,
        status: localStatus
      };
    }
    return {
      dataView: retrievedDataView,
      status: localStatus
    };
  }, [newDataViewPickerEnabled, retrievedDataView, localStatus]);
};
exports.useDataView = useDataView;