"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLICE_PREFIX = exports.PageScope = exports.DEFAULT_SECURITY_SOLUTION_DATA_VIEW_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_SECURITY_SOLUTION_DATA_VIEW_ID = exports.DEFAULT_SECURITY_SOLUTION_DATA_VIEW_ID = 'security-solution-default';
const SLICE_PREFIX = exports.SLICE_PREFIX = 'x-pack/security_solution/dataViewManager';

/**
 * This helps developers use the dataview that is set by default in the page corresponding to the scope.
 *
 * For example, if from a random page I want to use the dataview used in the alerts page,
 * I can use the @link{useDataView} hook with the PageScope.alerts to get it.
 */
let PageScope = exports.PageScope = /*#__PURE__*/function (PageScope) {
  PageScope["default"] = "default";
  PageScope["alerts"] = "alerts";
  PageScope["attacks"] = "attacks";
  PageScope["timeline"] = "timeline";
  PageScope["analyzer"] = "analyzer";
  PageScope["explore"] = "explore";
  return PageScope;
}({});