"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardToolBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/dashboard-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../../common");
var _kibana = require("../../common/lib/kibana");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/components/dashboard_tool_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardToolBarComponent = ({
  dashboardContainer,
  onLoad
}) => {
  const {
    setHeaderActionMenu
  } = (0, _kibana.useKibana)().services;
  const viewMode = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardContainer.viewMode$);
  const {
    navigateTo,
    getAppUrl
  } = (0, _kibana.useNavigation)();
  const redirectTo = (0, _react.useCallback)(({
    destination,
    id
  }) => {
    if (destination === 'listing') {
      navigateTo({
        deepLinkId: _common.SecurityPageName.dashboards
      });
    }
    if (destination === 'dashboard') {
      navigateTo({
        deepLinkId: _common.SecurityPageName.dashboards,
        path: id ? `${id}/edit` : `/create`
      });
    }
  }, [navigateTo]);
  const landingBreadcrumb = (0, _react.useMemo)(() => [{
    text: _constants.APP_NAME,
    href: getAppUrl({
      deepLinkId: _common.SecurityPageName.landing
    })
  }], [getAppUrl]);
  (0, _react.useEffect)(() => {
    onLoad === null || onLoad === void 0 ? void 0 : onLoad(viewMode !== null && viewMode !== void 0 ? viewMode : 'view');
  }, [onLoad, viewMode]);
  const embedSettings = (0, _react.useMemo)(() => ({
    forceHideFilterBar: true,
    forceShowTopNavMenu: true,
    forceShowQueryInput: false,
    forceShowDatePicker: false
  }), []);
  const {
    showWriteControls
  } = (0, _kibana.useCapabilities)('dashboard_v2');
  return showWriteControls ? /*#__PURE__*/_react.default.createElement(_public.DashboardTopNav, {
    customLeadingBreadCrumbs: landingBreadcrumb,
    dashboardApi: dashboardContainer,
    forceHideUnifiedSearch: true,
    embedSettings: embedSettings,
    redirectTo: redirectTo,
    showBorderBottom: false,
    setCustomHeaderActionMenu: setHeaderActionMenu,
    showResetChange: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }) : null;
};
const DashboardToolBar = exports.DashboardToolBar = /*#__PURE__*/_react.default.memo(DashboardToolBarComponent);