"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskSeverityColors = exports.getRiskSeverityColors = exports.SEVERITY_COLOR = void 0;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Temporary solution until we have a decision for color palette https://github.com/elastic/kibana/issues/203387
const SEVERITY_COLOR = exports.SEVERITY_COLOR = {
  low: '#54B399',
  medium: '#D6BF57',
  high: '#DA8B45',
  critical: '#E7664C'
};
const getRiskSeverityColors = euiTheme => SEVERITY_COLOR;
exports.getRiskSeverityColors = getRiskSeverityColors;
const useRiskSeverityColors = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => getRiskSeverityColors(euiTheme), [euiTheme]);
};
exports.useRiskSeverityColors = useRiskSeverityColors;