"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStore = exports.createStoreFactory = exports.createStore = void 0;
var _reduxThunk = _interopRequireDefault(require("redux-thunk"));
var _redux = require("redux");
var _developmentOnly = require("redux-devtools-extension/developmentOnly");
var _reduceReducers = _interopRequireDefault(require("reduce-reducers"));
var _timeline = require("../../../common/api/timeline");
var _types = require("../../../common/types");
var _reducer = require("./grouping/reducer");
var _telemetry = require("../lib/telemetry");
var timelineActions = _interopRequireWildcard(require("../../timelines/store/actions"));
var _reducer2 = require("./reducer");
var _middleware = require("../../resolver/store/middleware");
var _factory = require("../../resolver/data_access_layer/factory");
var _store = require("../../sourcerer/store");
var _middlewares = require("./middlewares");
var _helpers = require("../../timelines/store/helpers");
var _notes = require("../../notes/store/notes.slice");
var _create_default_data_view = require("../../data_view_manager/utils/create_default_data_view");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let store = null;
const createStoreFactory = async (coreStart, startPlugins, subPlugins, storage, enableExperimental) => {
  var _startPlugins$timelin, _startPlugins$timelin2, _subPlugins$managemen, _subPlugins$explore$s, _resolverMiddlewareFa;
  const {
    kibanaDataViews,
    defaultDataView,
    signal
  } = await (0, _create_default_data_view.createDefaultDataView)({
    application: coreStart.application,
    http: coreStart.http,
    dataViewService: startPlugins.data.dataViews,
    uiSettings: coreStart.uiSettings,
    spaces: startPlugins.spaces,
    // TODO: (new data view picker) remove this in cleanup phase https://github.com/elastic/security-team/issues/12665
    skip: enableExperimental.newDataViewPickerEnabled
  });
  const timelineInitialState = {
    timeline: {
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      ...subPlugins.timelines.store.initialState.timeline,
      timelineById: {
        ...subPlugins.timelines.store.initialState.timeline.timelineById,
        ...(0, _helpers.addNewTimeline)({
          id: _types.TimelineId.active,
          timelineById: {},
          show: false,
          timelineType: _timeline.TimelineTypeEnum.default,
          columns: [],
          dataViewId: null,
          indexNames: []
        })
      }
    }
  };
  const dataTableInitialState = {
    dataTable: {
      tableById: {
        /* eslint-disable @typescript-eslint/no-non-null-assertion */
        ...subPlugins.alerts.storageDataTables.tableById,
        ...subPlugins.rules.storageDataTables.tableById,
        ...subPlugins.exceptions.storageDataTables.tableById,
        ...subPlugins.explore.exploreDataTables.hosts.tableById,
        ...subPlugins.explore.exploreDataTables.network.tableById,
        ...subPlugins.explore.exploreDataTables.users.tableById
        /* eslint-enable @typescript-eslint/no-non-null-assertion */
      }
    }
  };
  const groupsInitialState = {
    groups: _reducer.initialGroupingState
  };
  const analyzerInitialState = {
    analyzer: {}
  };
  const timelineReducer = (0, _reduceReducers.default)(timelineInitialState.timeline, (_startPlugins$timelin = (_startPlugins$timelin2 = startPlugins.timelines) === null || _startPlugins$timelin2 === void 0 ? void 0 : _startPlugins$timelin2.getTimelineReducer()) !== null && _startPlugins$timelin !== void 0 ? _startPlugins$timelin : {}, subPlugins.timelines.store.reducer.timeline);
  const initialState = (0, _reducer2.createInitialState)({
    ...subPlugins.explore.store.initialState,
    ...timelineInitialState,
    ...subPlugins.management.store.initialState
  }, {
    defaultDataView,
    kibanaDataViews,
    signalIndexName: signal.name,
    signalIndexMappingOutdated: signal.index_mapping_outdated,
    enableExperimental
  }, dataTableInitialState, groupsInitialState, analyzerInitialState, _notes.initialNotesState);
  const rootReducer = {
    ...subPlugins.explore.store.reducer,
    timeline: timelineReducer,
    ...subPlugins.management.store.reducer
  };
  return createStore(initialState, rootReducer, coreStart, storage, [...((_subPlugins$managemen = subPlugins.management.store.middleware) !== null && _subPlugins$managemen !== void 0 ? _subPlugins$managemen : []), ...((_subPlugins$explore$s = subPlugins.explore.store.middleware) !== null && _subPlugins$explore$s !== void 0 ? _subPlugins$explore$s : []), ...[(_resolverMiddlewareFa = (0, _middleware.resolverMiddlewareFactory)((0, _factory.dataAccessLayerFactory)(coreStart))) !== null && _resolverMiddlewareFa !== void 0 ? _resolverMiddlewareFa : []]]);
};
exports.createStoreFactory = createStoreFactory;
const timelineActionsWithNonserializablePayloads = [timelineActions.updateTimeline.type, timelineActions.addTimeline.type, timelineActions.initializeTimelineSettings.type];
const actionSanitizer = action => {
  if (action.type === _store.sourcererActions.setDataView.type) {
    return {
      ...action,
      payload: {
        ...action.payload,
        dataView: 'dataView',
        browserFields: 'browserFields',
        indexFields: 'indexFields',
        fields: 'fields'
      }
    };
  } else if (timelineActionsWithNonserializablePayloads.includes(action.type)) {
    const {
      type,
      payload
    } = action;
    if (type === timelineActions.addTimeline.type || type === timelineActions.updateTimeline.type) {
      return {
        ...action,
        payload: {
          ...payload,
          timeline: sanitizeTimelineModel(payload.timeline)
        }
      };
    } else if (type === timelineActions.initializeTimelineSettings.type) {
      return {
        ...action,
        payload: {
          ...payload,
          timeline: sanitizeTimelineModel(payload.timeline)
        }
      };
    }
  }
  return action;
};
const sanitizeDataView = dataView => {
  return {
    ...dataView,
    browserFields: 'browserFields',
    indexFields: 'indexFields',
    fields: 'fields',
    dataView: 'dataView'
  };
};
const sanitizeTimelineModel = timeline => {
  return {
    ...timeline,
    footerText: 'footerText',
    loadingText: 'loadingText'
  };
};
const stateSanitizer = state => {
  if (state.sourcerer) {
    return {
      ...state,
      sourcerer: {
        ...state.sourcerer,
        defaultDataView: sanitizeDataView(state.sourcerer.defaultDataView),
        kibanaDataViews: state.sourcerer.kibanaDataViews.map(sanitizeDataView)
      }
    };
  } else {
    return state;
  }
};

/**
 * Factory for Security App's redux store.
 */
const createStore = (state, pluginsReducer, kibana, storage, additionalMiddleware) => {
  const enhancerOptions = {
    name: 'Kibana Security Solution',
    actionsBlacklist: ['USER_MOVED_POINTER', 'USER_SET_RASTER_SIZE'],
    actionSanitizer: actionSanitizer,
    stateSanitizer: stateSanitizer
    // uncomment the following to enable redux action tracing
    // https://github.com/zalmoxisus/redux-devtools-extension/commit/64717bb9b3534ff616d9db56c2be680627c7b09d#diff-182cb140f8a0fd8bc37bbdcdad07bbadb9aebeb2d1b8ed026acd6132f2c88ce8R10
    // trace: true,
    // traceLimit: 100,
  };
  const composeEnhancers = (0, _developmentOnly.composeWithDevTools)(enhancerOptions);
  const middlewareEnhancer = (0, _redux.applyMiddleware)(...(0, _middlewares.createMiddlewares)(kibana, storage), _telemetry.telemetryMiddleware, ...(additionalMiddleware !== null && additionalMiddleware !== void 0 ? additionalMiddleware : []), _reduxThunk.default);
  store = (0, _redux.createStore)((0, _reducer2.createReducer)(pluginsReducer), state, composeEnhancers(middlewareEnhancer));
  return store;
};
exports.createStore = createStore;
const getStore = () => store;
exports.getStore = getStore;