"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorybookProviders = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _rxjs = require("rxjs");
var _styledComponents = require("styled-components");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _cellActions = require("@kbn/cell-actions");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _common = require("../../../common");
var _query_client_provider = require("../containers/query_client/query_client_provider");
var _create_store = require("./create_store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/mock/storybook_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const uiSettings = {
  get: setting => {
    switch (setting) {
      case 'dateFormat':
        return 'MMM D, YYYY @ HH:mm:ss.SSS';
      case 'dateFormat:scaled':
        return [['', 'HH:mm:ss.SSS']];
    }
  },
  get$: () => new _rxjs.Subject()
};
const coreMock = {
  application: {
    getUrlForApp: () => {},
    capabilities: {
      [_common.CASES_FEATURE_ID]: {}
    }
  },
  lens: {
    EmbeddableComponent: () => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 32
      }
    })
  },
  cases: {
    helpers: {
      getUICapabilities: () => ({})
    },
    hooks: {
      useCasesAddToExistingCaseModal: () => {},
      useCasesAddToNewCaseFlyout: () => {}
    }
  },
  data: {
    query: {
      filterManager: {}
    },
    search: {
      session: /*#__PURE__*/_react.default.createRef()
    },
    actions: {
      createFiltersFromValueClickAction: () => {}
    }
  },
  settings: {
    client: {
      get: () => {},
      get$: () => new _rxjs.Subject(),
      set: () => {}
    }
  },
  uiSettings,
  notifications: {
    toasts: {
      addError: () => {},
      addSuccess: () => {},
      addWarning: () => {},
      remove: () => {}
    }
  },
  timelines: {
    getHoverActions: () => ({
      getAddToTimelineButton: () => {},
      getCopyButton: () => {},
      getFilterForValueButton: () => {},
      getFilterOutValueButton: () => {}
    })
  }
};
const KibanaReactContext = (0, _public.createKibanaReactContext)(coreMock);

/**
 * A utility for wrapping components in Storybook that provides access to the most common React contexts used by security components.
 * It is a simplified version of TestProvidersComponent.
 * To reuse TestProvidersComponent here, we need to remove all references to jest from mocks.
 */
const StorybookProviders = ({
  children
}) => {
  const store = (0, _create_store.createMockStore)();
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: coreMock,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: () => Promise.resolve([]),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_styledComponents.ThemeProvider, {
    theme: () => ({
      eui: _uiTheme.euiLightVars,
      darkMode: false
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }, children)))))));
};
exports.StorybookProviders = StorybookProviders;