"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigateInTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _constants = require("../../../data_view_manager/constants");
var _use_select_data_view = require("../../../data_view_manager/hooks/use_select_data_view");
var _use_create_timeline = require("../../../timelines/hooks/use_create_timeline");
var _actions = require("../../../timelines/store/actions");
var _store = require("../../store");
var _inputs = require("../../store/inputs");
var _constants2 = require("../../store/inputs/constants");
var _timeline = require("../../../../common/types/timeline");
var _timeline2 = require("../../../../common/api/timeline");
var _actions2 = require("../../store/actions");
var _use_experimental_features = require("../use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This hook returns a callback that, when called, opens the timeline modal.
 * It clears the current timeline or timeline template.
 * Parameters can be passed to configure the timeline as it opens
 */
const useInvestigateInTimeline = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const signalIndexName = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const clearTimelineTemplate = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineTypeEnum.template
  });
  const clearTimelineDefault = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _timeline.TimelineId.active,
    timelineType: _timeline2.TimelineTypeEnum.default
  });
  const setSelectedDataView = (0, _use_select_data_view.useSelectDataView)();
  const investigateInTimeline = (0, _react.useCallback)(async ({
    query,
    dataProviders,
    filters,
    timeRange,
    keepDataView
  }) => {
    const hasTemplateProviders = dataProviders && dataProviders.find(provider => provider.type === 'template');
    const clearTimeline = hasTemplateProviders ? clearTimelineTemplate : clearTimelineDefault;
    if (dataProviders || filters || query) {
      // Reset the current timeline
      if (timeRange) {
        await clearTimeline({
          timeRange
        });
      } else {
        await clearTimeline();
      }
      if (dataProviders) {
        // Update the timeline's providers to match the current prevalence field query
        dispatch((0, _actions.updateProviders)({
          id: _timeline.TimelineId.active,
          providers: dataProviders
        }));
      }
      // Use filters if more than a certain amount of ids for dom performance.
      if (filters) {
        dispatch((0, _actions.setFilters)({
          id: _timeline.TimelineId.active,
          filters
        }));
      }
      if (query) {
        dispatch((0, _actions.applyKqlFilterQuery)({
          id: _timeline.TimelineId.active,
          filterQuery: {
            kuery: {
              kind: 'kuery',
              expression: query.query
            },
            serializedQuery: query.query
          }
        }));
      }
      // Only show detection alerts
      // (This is required so the timeline event count matches the prevalence count)
      if (!keepDataView) {
        if (newDataViewPickerEnabled) {
          setSelectedDataView({
            scope: _constants.PageScope.timeline,
            id: defaultDataView.id,
            fallbackPatterns: [signalIndexName || '']
          });
        } else {
          dispatch(_actions2.sourcererActions.setSelectedDataView({
            id: _constants.PageScope.timeline,
            selectedDataViewId: defaultDataView.id,
            selectedPatterns: [signalIndexName || '']
          }));
        }
      }
      // Unlock the time range from the global time range
      dispatch(_inputs.inputsActions.removeLinkTo([_constants2.InputsModelId.timeline, _constants2.InputsModelId.global]));
    }
  }, [clearTimelineTemplate, clearTimelineDefault, dispatch, newDataViewPickerEnabled, setSelectedDataView, defaultDataView.id, signalIndexName]);
  return {
    investigateInTimeline
  };
};
exports.useInvestigateInTimeline = useInvestigateInTimeline;