"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldIgnoreAlertFilters = exports.removeIgnoredAlertFilters = exports.rawEvents = exports.isDetectionsAlertsTable = exports.getPageScope = exports.getOptions = exports.detectionAlertsTables = exports.defaultOptions = exports.allEvents = exports.alertEvents = exports.IGNORED_ALERT_FILTERS = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../data_view_manager/constants");
var _timeline = require("../../../../common/types/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** the following scopes are detection alert tables */
const detectionAlertsTables = exports.detectionAlertsTables = [_securitysolutionDataTable.TableId.alertsOnAlertsPage, _securitysolutionDataTable.TableId.alertsOnAttacksPage, _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage, _securitysolutionDataTable.TableId.alertsOnCasePage, _timeline.TimelineId.casePage];

/** A (stable) array containing only the 'All events' option */
const allEvents = exports.allEvents = [{
  value: 'all',
  inputDisplay: i18n.ALL_EVENTS,
  'data-test-subj': 'option-all'
}];

/** A (stable) array containing only the 'Raw events' option */
const rawEvents = exports.rawEvents = [{
  value: 'raw',
  inputDisplay: i18n.RAW_EVENTS,
  'data-test-subj': 'option-raw'
}];

/** A (stable) array containing only the 'Alert events' option */
const alertEvents = exports.alertEvents = [{
  value: 'alert',
  inputDisplay: i18n.ALERT_EVENTS,
  'data-test-subj': 'option-alert'
}];

/** A (stable) array containing the default Top N options */
const defaultOptions = exports.defaultOptions = [...rawEvents, ...alertEvents];

/**
 * Returns the options to be displayed in a Top N view select. When
 * an `activeTimelineEventType` is provided, an array containing
 * just one option (corresponding to `activeTimelineEventType`)
 * will be returned, to ensure the data displayed in the Top N
 * is always in sync with the `EventType` chosen by the user in
 * the active timeline.
 */
const getOptions = activeTimelineEventsType => {
  switch (activeTimelineEventsType) {
    case 'all':
      return allEvents;
    case 'raw':
      return rawEvents;
    case 'alert':
      return alertEvents;
    default:
      return defaultOptions;
  }
};

/** returns true if the specified timelineId is a detections alert table */
exports.getOptions = getOptions;
const isDetectionsAlertsTable = scopeId => scopeId ? detectionAlertsTables.includes(scopeId) : false;

/**
 * The following fields are used to filter alerts tables, (i.e. tables in the
 * `Security > Alert` and `Security > Rule > Details` pages). These fields,
 * MUST be ignored when showing Top N alerts for `raw` documents, because
 * the raw documents don't include them.
 */
exports.isDetectionsAlertsTable = isDetectionsAlertsTable;
const IGNORED_ALERT_FILTERS = exports.IGNORED_ALERT_FILTERS = [_ruleDataUtils.ALERT_ACTION_GROUP, _ruleDataUtils.ALERT_BUILDING_BLOCK_TYPE,
// an "Additional filters" option on the alerts table
_ruleDataUtils.ALERT_DURATION, _ruleDataUtils.ALERT_END, _ruleDataUtils.ALERT_EVALUATION_THRESHOLD, _ruleDataUtils.ALERT_EVALUATION_VALUE, _ruleDataUtils.ALERT_INSTANCE_ID, _ruleDataUtils.ALERT_NAMESPACE, _ruleDataUtils.ALERT_RULE_NAMESPACE, _ruleDataUtils.ALERT_RULE_CONSUMER, _ruleDataUtils.ALERT_RULE_PRODUCER, _ruleDataUtils.ALERT_REASON, _ruleDataUtils.ALERT_RISK_SCORE, _ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_WORKFLOW_REASON, _ruleDataUtils.ALERT_WORKFLOW_STATUS,
// open | acknowledged | closed filter
_ruleDataUtils.ALERT_WORKFLOW_USER, _ruleDataUtils.ALERT_RULE_AUTHOR, _ruleDataUtils.ALERT_RULE_CREATED_AT, _ruleDataUtils.ALERT_RULE_CREATED_BY, _ruleDataUtils.ALERT_RULE_DESCRIPTION, _ruleDataUtils.ALERT_RULE_ENABLED, _ruleDataUtils.ALERT_RULE_FROM, _ruleDataUtils.ALERT_RULE_INTERVAL, _ruleDataUtils.ALERT_RULE_LICENSE, _ruleDataUtils.ALERT_RULE_NAME,
// not a built-in view filter, but frequently applied via the `Filter In` and `Filter Out` actions
_ruleDataUtils.ALERT_RULE_NOTE, _ruleDataUtils.ALERT_RULE_PARAMETERS, _ruleDataUtils.ALERT_RULE_REFERENCES, _ruleDataUtils.ALERT_RULE_RULE_ID,
// filters alerts to a single rule on the Security > Rules > details pages
_ruleDataUtils.ALERT_RULE_RULE_NAME_OVERRIDE, _ruleDataUtils.ALERT_RULE_TAGS, _ruleDataUtils.ALERT_RULE_TO, _ruleDataUtils.ALERT_RULE_TYPE, _ruleDataUtils.ALERT_RULE_TYPE_ID, _ruleDataUtils.ALERT_RULE_UPDATED_AT, _ruleDataUtils.ALERT_RULE_UPDATED_BY, _ruleDataUtils.ALERT_RULE_UUID, _ruleDataUtils.ALERT_RULE_CATEGORY, _ruleDataUtils.ALERT_RULE_VERSION, _ruleDataUtils.ALERT_SEVERITY, _ruleDataUtils.ALERT_START, _ruleDataUtils.ALERT_SYSTEM_STATUS, _ruleDataUtils.ALERT_UUID, 'signal.rule.building_block_type', 'signal.rule.id', 'signal.rule.name', 'signal.rule.threat_mapping', 'signal.status'];

/**
 * returns true if the Top N query should ignore filters specific to alerts
 * when querying raw documents
 *
 * @see IGNORED_ALERT_FILTERS
 */
const shouldIgnoreAlertFilters = ({
  tableId,
  view
}) => view === 'raw' && isDetectionsAlertsTable(tableId);

/**
 * returns a new set of `filters` that don't contain the fields specified in
 * `IGNORED_ALERT_FILTERS` when they should be ignored
 *
 * @see IGNORED_ALERT_FILTERS
 */
exports.shouldIgnoreAlertFilters = shouldIgnoreAlertFilters;
const removeIgnoredAlertFilters = ({
  filters,
  tableId,
  view
}) => {
  if (!shouldIgnoreAlertFilters({
    tableId,
    view
  })) {
    return filters; // unmodified filters
  }
  return filters.filter(x => !IGNORED_ALERT_FILTERS.includes(`${x.meta.key}`));
};

/** returns the PageScope applicable to the specified timelineId and view */
exports.removeIgnoredAlertFilters = removeIgnoredAlertFilters;
const getPageScope = ({
  scopeId,
  view
}) => {
  // When alerts should be ignored, use the `default` Sourcerer scope,
  // because it does NOT include alert indexes:
  if (shouldIgnoreAlertFilters({
    tableId: scopeId,
    view
  })) {
    return _constants.PageScope.default; // no alerts in this scope
  }
  if (isDetectionsAlertsTable(scopeId)) {
    return _constants.PageScope.alerts;
  }
  if (scopeId === _timeline.TimelineId.active) {
    return _constants.PageScope.timeline;
  }
  return _constants.PageScope.default;
};
exports.getPageScope = getPageScope;