"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRisonObject = exports.isRegularString = exports.decodeRison = void 0;
var _rison = require("@kbn/rison");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const decodeRison = value => {
  try {
    return (0, _rison.decode)(value);
  } catch (error) {
    return null;
  }
};
exports.decodeRison = decodeRison;
const isRisonObject = value => {
  return (0, _fp.isObject)(value);
};
exports.isRisonObject = isRisonObject;
const isRegularString = value => {
  return (0, _fp.isString)(value);
};
exports.isRegularString = isRegularString;