"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEventNoteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _notes_button = require("../../../timelines/components/timeline/notes/notes_button");
var _timeline = require("../../../../common/api/timeline");
var _user_privileges = require("../user_privileges");
var _action_icon_item = require("./action_icon_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_actions/add_note_icon_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NOTES_DISABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.body.notes.disableEventTooltip', {
  defaultMessage: 'Notes cannot be added here while editing a template Timeline.'
});
const NOTES_ADD_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.body.notes.addNoteTooltip', {
  defaultMessage: 'Add note'
});
const NO_NOTES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.timeline.body.notes.addNoteTooltip', {
  defaultMessage: 'No notes available'
});
const ADD_NOTES_COUNT_TOOLTIP = ({
  notesCount
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.body.notes.addNote.multipleNotesAvailableTooltip', {
  values: {
    notesCount
  },
  defaultMessage: '{notesCount} {notesCount, plural, one {note} other {notes}  } available. Click to view {notesCount, plural, one {it} other {them}} and add more.'
});
const VIEW_NOTES_COUNT_TOOLTIP = ({
  notesCount
}) => _i18n.i18n.translate('xpack.securitySolution.timeline.body.notes.addNote.multipleNotesAvailableTooltip', {
  values: {
    notesCount
  },
  defaultMessage: '{notesCount} {notesCount, plural, one {note} other {notes}  } available. Click to view {notesCount, plural, one {it} other {them}}.'
});
const AddEventNoteActionComponent = ({
  ariaLabel,
  timelineType,
  toggleShowNotes,
  eventId,
  notesCount
}) => {
  const {
    notesPrivileges: {
      crud: canAddNotes,
      read: canViewNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const tooltip = (0, _react.useMemo)(() => {
    if (timelineType === _timeline.TimelineTypeEnum.template) {
      return NOTES_DISABLE_TOOLTIP;
    }
    if (canAddNotes) {
      return notesCount > 0 ? ADD_NOTES_COUNT_TOOLTIP({
        notesCount
      }) : NOTES_ADD_TOOLTIP;
    }
    if (canViewNotes) {
      return notesCount > 0 ? VIEW_NOTES_COUNT_TOOLTIP({
        notesCount
      }) : NO_NOTES_TOOLTIP;
    }

    // we can return an empty string for tooltip because the icon is actually no shown at all
    return '';
  }, [canAddNotes, canViewNotes, notesCount, timelineType]);
  const disabled = (0, _react.useMemo)(() => !canAddNotes && notesCount === 0, [canAddNotes, notesCount]);
  return /*#__PURE__*/_react.default.createElement(_action_icon_item.ActionIconItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_notes_button.NotesButton, {
    ariaLabel: ariaLabel,
    "data-test-subj": "add-note",
    isDisabled: disabled,
    timelineType: timelineType,
    toggleShowNotes: toggleShowNotes,
    toolTip: tooltip,
    eventId: eventId,
    notesCount: notesCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }));
};
AddEventNoteActionComponent.displayName = 'AddEventNoteActionComponent';
const AddEventNoteAction = exports.AddEventNoteAction = /*#__PURE__*/_react.default.memo(AddEventNoteActionComponent);