"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Actions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _notes = require("../../../notes/store/notes.slice");
var _selectors = require("../../../timelines/store/selectors");
var _helpers = require("../../../timelines/components/timeline/body/helpers");
var _helpers2 = require("../../../helpers");
var _investigate_in_resolver = require("../../../detections/components/alerts_table/timeline_actions/investigate_in_resolver");
var _types = require("../../../../common/types");
var _add_note_icon_item = require("./add_note_icon_item");
var _pin_event_action = require("./pin_event_action");
var _use_selector = require("../../hooks/use_selector");
var _defaults = require("../../../timelines/store/defaults");
var _use_start_transaction = require("../../lib/apm/use_start_transaction");
var _use_license = require("../../hooks/use_license");
var _user_actions = require("../../lib/apm/user_actions");
var _styles = require("../../../timelines/components/timeline/styles");
var _alert_context_menu = require("../../../detections/components/alerts_table/timeline_actions/alert_context_menu");
var _investigate_in_timeline_action = require("../../../detections/components/alerts_table/timeline_actions/investigate_in_timeline_action");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers3 = require("./helpers");
var _use_navigate_to_analyzer = require("../../../flyout/document_details/shared/hooks/use_navigate_to_analyzer");
var _use_navigate_to_session_view = require("../../../flyout/document_details/shared/hooks/use_navigate_to_session_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_actions/actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionsContainer = _styledComponents.default.div`
  align-items: center;
  display: flex;
`;
const ActionsComponent = ({
  ariaRowindex,
  columnValues,
  disableExpandAction = false,
  disablePinAction = true,
  disableTimelineAction = false,
  ecsData,
  eventId,
  eventIdToNoteIds,
  isEventViewer = false,
  onEventDetailsPanelOpened,
  onRuleChange,
  refetch,
  showNotes,
  timelineId,
  toggleShowNotes
}) => {
  const {
    timelineType,
    savedObjectId
  } = (0, _use_selector.useShallowEqualSelector)(state => (0, _helpers2.isTimelineScope)(timelineId) ? (0, _selectors.selectTimelineById)(state, timelineId) : _defaults.timelineDefaults);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const eventType = (0, _helpers.getEventType)(ecsData);
  const {
    navigateToAnalyzer
  } = (0, _use_navigate_to_analyzer.useNavigateToAnalyzer)({
    isFlyoutOpen: false,
    eventId,
    indexName: ecsData._index,
    scopeId: timelineId
  });
  const {
    navigateToSessionView
  } = (0, _use_navigate_to_session_view.useNavigateToSessionView)({
    isFlyoutOpen: false,
    eventId,
    indexName: ecsData._index,
    scopeId: timelineId
  });
  const handleClick = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_ANALYZER
    });
    navigateToAnalyzer();
  }, [startTransaction, navigateToAnalyzer]);
  const sessionViewConfig = (0, _react.useMemo)(() => {
    var _process$entry_leader, _process$entry_leader2, _process$entry_leader3, _process$entry_leader4, _kibana$alert, _kibana$alert$ancesto, _kibana$alert$ancesto2, _process$entity_id, _ecsData$kibana, _ecsData$kibana$alert;
    const {
      process,
      _id,
      _index,
      timestamp,
      kibana
    } = ecsData;
    const sessionEntityId = process === null || process === void 0 ? void 0 : (_process$entry_leader = process.entry_leader) === null || _process$entry_leader === void 0 ? void 0 : (_process$entry_leader2 = _process$entry_leader.entity_id) === null || _process$entry_leader2 === void 0 ? void 0 : _process$entry_leader2[0];
    const sessionStartTime = process === null || process === void 0 ? void 0 : (_process$entry_leader3 = process.entry_leader) === null || _process$entry_leader3 === void 0 ? void 0 : (_process$entry_leader4 = _process$entry_leader3.start) === null || _process$entry_leader4 === void 0 ? void 0 : _process$entry_leader4[0];
    const index = (kibana === null || kibana === void 0 ? void 0 : (_kibana$alert = kibana.alert) === null || _kibana$alert === void 0 ? void 0 : (_kibana$alert$ancesto = _kibana$alert.ancestors) === null || _kibana$alert$ancesto === void 0 ? void 0 : (_kibana$alert$ancesto2 = _kibana$alert$ancesto.index) === null || _kibana$alert$ancesto2 === void 0 ? void 0 : _kibana$alert$ancesto2[0]) || _index;
    if (index === undefined || sessionEntityId === undefined || sessionStartTime === undefined) {
      return null;
    }
    const jumpToEntityId = process === null || process === void 0 ? void 0 : (_process$entity_id = process.entity_id) === null || _process$entity_id === void 0 ? void 0 : _process$entity_id[0];
    const investigatedAlertId = eventType === 'signal' || eventType === 'eql' ? _id : undefined;
    const jumpToCursor = investigatedAlertId && ((_ecsData$kibana = ecsData.kibana) === null || _ecsData$kibana === void 0 ? void 0 : (_ecsData$kibana$alert = _ecsData$kibana.alert.original_time) === null || _ecsData$kibana$alert === void 0 ? void 0 : _ecsData$kibana$alert[0]) || timestamp;
    return {
      index,
      sessionEntityId,
      sessionStartTime,
      jumpToEntityId,
      jumpToCursor,
      investigatedAlertId
    };
  }, [ecsData, eventType]);
  const openSessionView = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_SESSION_VIEW
    });
    navigateToSessionView();
  }, [navigateToSessionView, startTransaction]);
  const onExpandEvent = (0, _react.useCallback)(() => {
    onEventDetailsPanelOpened();
  }, [onEventDetailsPanelOpened]);
  const selectNotesByDocumentId = (0, _react.useMemo)(() => (0, _notes.makeSelectNotesByDocumentId)(), []);
  /* only applicable for new event based notes */
  const documentBasedNotes = (0, _reactRedux.useSelector)(state => selectNotesByDocumentId(state, eventId));
  const selectDocumentNotesBySavedObjectId = (0, _react.useMemo)(() => (0, _notes.makeSelectDocumentNotesBySavedObjectId)(), []);
  const documentBasedNotesInTimeline = (0, _reactRedux.useSelector)(state => selectDocumentNotesBySavedObjectId(state, eventId, savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : ''));

  /* note ids associated with the document AND attached to the current timeline, used for pinning */
  const timelineNoteIds = (0, _react.useMemo)(() =>
  // if timeline is unsaved, there is no notes associated to timeline yet
  savedObjectId ? documentBasedNotesInTimeline.map(note => note.noteId) : [], [documentBasedNotesInTimeline, savedObjectId]);

  // we hide the analyzer icon if the data is not available for the resolver
  // or if we are on the cases alerts table and the visualization in flyout advanced setting is disabled
  const showAnalyzerIcon = (0, _investigate_in_resolver.useIsInvestigateInResolverActionEnabled)(ecsData);

  // we hide the session view icon if the session view is not available
  // or if we are on the cases alerts table and the visualization in flyout advanced setting is disabled
  // or if the user is not on an enterprise license or on the kubernetes page
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const showSessionViewIcon = (0, _react.useMemo)(() => sessionViewConfig !== null && isEnterprisePlus, [isEnterprisePlus, sessionViewConfig]);
  return /*#__PURE__*/_react.default.createElement(ActionsContainer, {
    "data-test-subj": "actions-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !disableExpandAction && /*#__PURE__*/_react.default.createElement("div", {
    key: "expand-event",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers3.DEFAULT_ACTION_BUTTON_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "expand-event-tool-tip",
    content: i18n.VIEW_DETAILS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.VIEW_DETAILS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "expand-event",
    iconType: "expand",
    onClick: onExpandEvent,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 17
    }
  })))), !disableTimelineAction && timelineId !== _types.TimelineId.active && /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_action.InvestigateInTimelineAction, {
    ariaLabel: i18n.SEND_ALERT_TO_TIMELINE_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    key: "investigate-in-timeline",
    ecsRowData: ecsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }), !isEventViewer && showNotes && /*#__PURE__*/_react.default.createElement(_add_note_icon_item.AddEventNoteAction, {
    ariaLabel: i18n.ADD_NOTES_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    key: "add-event-note",
    timelineType: timelineType,
    notesCount: documentBasedNotes.length,
    eventId: eventId,
    toggleShowNotes: toggleShowNotes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }), !isEventViewer && !disablePinAction && /*#__PURE__*/_react.default.createElement(_pin_event_action.PinEventAction, {
    ariaRowindex: ariaRowindex,
    columnValues: columnValues,
    eventId: eventId,
    eventIdToNoteIds: eventIdToNoteIds,
    isAlert: (0, _helpers3.isAlert)(eventType),
    key: "pin-event",
    noteIds: timelineNoteIds,
    timelineId: timelineId,
    timelineType: timelineType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_context_menu.AlertContextMenu, {
    ariaLabel: i18n.MORE_ACTIONS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    ariaRowindex: ariaRowindex,
    columnValues: columnValues,
    key: "alert-context-menu",
    ecsRowData: ecsData,
    scopeId: timelineId,
    disabled: false,
    onRuleChange: onRuleChange,
    refetch: refetch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }), showAnalyzerIcon ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers3.DEFAULT_ACTION_BUTTON_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "view-in-analyzer-tool-tip",
    content: i18n.ACTION_INVESTIGATE_IN_RESOLVER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "view-in-analyzer",
    iconType: "analyzeEvent",
    onClick: handleClick,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 17
    }
  })))) : null, showSessionViewIcon ? /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _helpers3.DEFAULT_ACTION_BUTTON_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "session-view-tool-tip",
    content: i18n.OPEN_SESSION_VIEW,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.VIEW_DETAILS_FOR_ROW({
      ariaRowindex,
      columnValues
    }),
    "data-test-subj": "session-view-button",
    iconType: "sessionViewer",
    onClick: openSessionView,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  })))) : null));
};
ActionsComponent.displayName = 'ActionsComponent';
const Actions = exports.Actions = /*#__PURE__*/_react.default.memo(ActionsComponent);