"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isP1DTFormatterSetting = exports.PreferenceFormattedP1DTDate = exports.PreferenceFormattedDateFromPrimitive = exports.PreferenceFormattedDate = exports.FormattedRelativePreferenceDate = exports.FormattedDate = void 0;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../lib/kibana");
var _empty_value = require("../empty_value");
var _localized_date_tooltip = require("../localized_date_tooltip");
var _maybe_date = require("./maybe_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/formatted_date/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PreferenceFormattedDate = exports.PreferenceFormattedDate = /*#__PURE__*/_react.default.memo(/* eslint-disable-next-line react-hooks/rules-of-hooks */
({
  value,
  dateFormat = (0, _kibana.useDateFormat)()
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _momentTimezone.default.tz(value, (0, _kibana.useTimeZone)()).format(dateFormat)));
PreferenceFormattedDate.displayName = 'PreferenceFormattedDate';
const PreferenceFormattedDateFromPrimitive = ({
  value
}) => {
  if (value == null) {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  }
  const maybeDate = (0, _maybe_date.getMaybeDate)(value);
  if (!maybeDate.isValid()) {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  }
  const date = maybeDate.toDate();
  return /*#__PURE__*/_react.default.createElement(PreferenceFormattedDate, {
    value: date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 10
    }
  });
};
exports.PreferenceFormattedDateFromPrimitive = PreferenceFormattedDateFromPrimitive;
PreferenceFormattedDateFromPrimitive.displayName = 'PreferenceFormattedDateFromPrimitive';

/**
 * This function may be passed to `Array.find()` to locate the `P1DT`
 * configuration (sub) setting, a string array that contains two entries
 * like the following example: `['P1DT', 'YYYY-MM-DD']`.
 */
const isP1DTFormatterSetting = formatNameFormatterPair => Array.isArray(formatNameFormatterPair) && formatNameFormatterPair[0] === 'P1DT' && formatNameFormatterPair.length === 2;

/**
 * Renders a date in `P1DT` format, e.g. `YYYY-MM-DD`, as specified by
 * the `P1DT1` entry in the `dateFormat:scaled` Kibana Advanced setting.
 *
 * If the `P1DT` format is not specified in the `dateFormat:scaled` setting,
 * the fallback format `YYYY-MM-DD` will be applied
 */
exports.isP1DTFormatterSetting = isP1DTFormatterSetting;
const PreferenceFormattedP1DTDate = exports.PreferenceFormattedP1DTDate = /*#__PURE__*/_react.default.memo(({
  value
}) => {
  /**
   * A fallback "format name / formatter" 2-tuple for the `P1DT` formatter, which is
   * one of many such pairs expected to be contained in the `dateFormat:scaled`
   * Kibana advanced setting.
   */
  const FALLBACK_DATE_FORMAT_SCALED_P1DT = ['P1DT', 'YYYY-MM-DD'];

  // Read the 'dateFormat:scaled' Kibana Advanced setting, which contains 2-tuple sub-settings:
  const [scaledDateFormatPreference] = (0, _kibana.useUiSetting$)('dateFormat:scaled');

  // attempt to find the nested `['P1DT', 'formatString']` setting
  const maybeP1DTFormatter = Array.isArray(scaledDateFormatPreference) ? scaledDateFormatPreference.find(isP1DTFormatterSetting) : null;
  const p1dtFormat = Array.isArray(maybeP1DTFormatter) && maybeP1DTFormatter.length === 2 ? maybeP1DTFormatter[1] : FALLBACK_DATE_FORMAT_SCALED_P1DT[1];
  return /*#__PURE__*/_react.default.createElement(PreferenceFormattedDate, {
    dateFormat: p1dtFormat,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 10
    }
  });
});
PreferenceFormattedP1DTDate.displayName = 'PreferenceFormattedP1DTDate';

/**
 * Renders the specified date value in a format determined by the user's preferences,
 * with a tooltip that renders:
 * - the name of the field
 * - a humanized relative date (e.g. 16 minutes ago)
 * - a long representation of the date that includes the day of the week (e.g. Thursday, March 21, 2019 6:47pm)
 * - the raw date value (e.g. 2019-03-22T00:47:46Z)
 */

const FormattedDate = exports.FormattedDate = /*#__PURE__*/_react.default.memo(({
  value,
  fieldName,
  className = '',
  dateFormat,
  tooltipProps
}) => {
  if (value == null) {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  }
  const maybeDate = (0, _maybe_date.getMaybeDate)(value);
  return maybeDate.isValid() ? /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
    date: maybeDate.toDate(),
    fieldName: fieldName,
    className: className,
    tooltipProps: tooltipProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(PreferenceFormattedDate, {
    value: maybeDate.toDate(),
    dateFormat: dateFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })) : (0, _empty_value.getOrEmptyTagFromValue)(value);
});
FormattedDate.displayName = 'FormattedDate';
/**
 * Renders the specified date value according to under/over configured by relativeThresholdInHrs in hours (default 1 hr)
 * Under the relativeThresholdInHrs = relative format
 * Over the relativeThresholdInHrs  = in a format determined by the user's preferences (can be overridden via prop),
 * with a tooltip that renders:
 * - the name of the field
 * - a humanized relative date (e.g. 16 minutes ago)
 * - a long representation of the date that includes the day of the week (e.g. Thursday, March 21, 2019 6:47pm)
 * - the raw date value (e.g. 2019-03-22T00:47:46Z)
 */
const FormattedRelativePreferenceDate = exports.FormattedRelativePreferenceDate = /*#__PURE__*/_react.default.memo(({
  value,
  dateFormat,
  tooltipFieldName,
  tooltipAnchorClassName,
  relativeThresholdInHrs = 1
}) => {
  if (value == null) {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  }
  const maybeDate = (0, _maybe_date.getMaybeDate)(value);
  if (!maybeDate.isValid()) {
    return (0, _empty_value.getOrEmptyTagFromValue)(value);
  }
  const date = maybeDate.toDate();
  const shouldDisplayPreferenceTime = (0, _momentTimezone.default)(date).add(relativeThresholdInHrs, 'hours').isBefore(new Date());
  return /*#__PURE__*/_react.default.createElement(_localized_date_tooltip.LocalizedDateTooltip, {
    date: date,
    fieldName: tooltipFieldName,
    className: tooltipAnchorClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, shouldDisplayPreferenceTime ? /*#__PURE__*/_react.default.createElement(PreferenceFormattedDate, {
    "data-test-subj": "preference-time",
    value: date,
    dateFormat: dateFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    "data-test-subj": "relative-time",
    value: date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }));
});
FormattedRelativePreferenceDate.displayName = 'FormattedRelativePreferenceDate';