"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMovingAttacksCallout = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to manage the visibility of the moving attacks callout
 */
const useMovingAttacksCallout = () => {
  const [isMovingAttacksCalloutVisible, setMovingAttacksCalloutVisible] = (0, _useLocalStorage.default)(`${_elasticAssistant.DEFAULT_ASSISTANT_NAMESPACE}.${_elasticAssistant.ATTACK_DISCOVERY_STORAGE_KEY}.${_elasticAssistant.MOVING_ATTACKS_CALLOUT_LOCAL_STORAGE_KEY}`, true);
  const hideMovingAttacksCallout = (0, _react.useCallback)(() => setMovingAttacksCalloutVisible(false), [setMovingAttacksCalloutVisible]);
  const showMovingAttacksCallout = (0, _react.useCallback)(() => setMovingAttacksCalloutVisible(true), [setMovingAttacksCalloutVisible]);
  return {
    isMovingAttacksCalloutVisible,
    hideMovingAttacksCallout,
    showMovingAttacksCallout
  };
};
exports.useMovingAttacksCallout = useMovingAttacksCallout;