"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MovingAttacksCallout = exports.HIDE_BUTTON_TEST_DATA_ID = exports.CALLOUT_TEST_DATA_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _deeplinksSecurity = require("@kbn/deeplinks-security");
var _links = require("../../../common/components/links");
var _use_moving_attacks_callout = require("./use_moving_attacks_callout");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/moving_attacks_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CALLOUT_TEST_DATA_ID = exports.CALLOUT_TEST_DATA_ID = 'moving-attacks-callout';
const HIDE_BUTTON_TEST_DATA_ID = exports.HIDE_BUTTON_TEST_DATA_ID = 'hide-callout-button';

/**
 * Component to display a moving attacks callout
 */
const MovingAttacksCallout = exports.MovingAttacksCallout = /*#__PURE__*/_react.default.memo(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isMovingAttacksCalloutVisible,
    hideMovingAttacksCallout
  } = (0, _use_moving_attacks_callout.useMovingAttacksCallout)();
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('m');
  const calloutDescriptionWidth = (0, _react2.css)`
    max-width: ${isSmall ? 'auto' : '1000px'};
  `;
  const hideButtonSpacing = (0, _react2.css)`
    margin-left: ${euiTheme.size.s};
  `;
  return isMovingAttacksCalloutVisible ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.attackDiscovery.movingAttacksCallout.title",
      defaultMessage: "Attack Discovery is moving to Detections",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }),
    iconType: "bolt",
    "data-test-subj": CALLOUT_TEST_DATA_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    css: calloutDescriptionWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.attackDiscovery.movingAttacksCallout.description",
    defaultMessage: "You can now schedule scans and view promoted attacks from Detections -> Attacks. Manual scans are still available only here, on the legacy page. Attack Discovery will move completely to the Detections section in a future release.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    fill: true,
    size: "s",
    deepLinkId: _deeplinksSecurity.SecurityPageName.attacks,
    "data-test-subj": "viewAttacksButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, i18n.VIEW_ATTACKS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": HIDE_BUTTON_TEST_DATA_ID,
    css: hideButtonSpacing,
    size: "s",
    onClick: hideMovingAttacksCallout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, i18n.HIDE_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  })) : null;
});
MovingAttacksCallout.displayName = 'MovingAttacksCallout';