"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssistantProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _kibana = require("../common/lib/kibana");
var _use_license = require("../common/hooks/use_license");
var _use_find_prompt_contexts = require("./content/prompt_contexts/use_find_prompt_contexts");
var _comment_actions_portal = require("./comment_actions/comment_actions_portal");
var _augment_message_code_blocks_portal = require("./use_augment_message_code_blocks/augment_message_code_blocks_portal");
var _use_elastic_assistant_shared_state_signal_index = require("./use_elastic_assistant_shared_state_signal_index/use_elastic_assistant_shared_state_signal_index");
var _use_migrate_conversation_from_local_storage = require("./migrate_conversations_from_local_storage/use_migrate_conversation_from_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/assistant/provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component configures the Elastic AI Assistant context provider for the Security Solution app.
 */
const AssistantProvider = ({
  children
}) => {
  var _assistantContextValu, _assistantContextValu2;
  const {
    http,
    notifications,
    elasticAssistantSharedState
  } = (0, _kibana.useKibana)().services;
  const assistantContextValue = (0, _useObservable.default)(elasticAssistantSharedState.assistantContextValue.getAssistantContextValue$());
  const hasEnterpriseLicence = _use_license.licenseService.isEnterprise();
  (0, _use_elastic_assistant_shared_state_signal_index.useElasticAssistantSharedStateSignalIndex)();
  const promptContexts = (0, _use_find_prompt_contexts.useFindPromptContexts)({
    context: {
      isAssistantEnabled: hasEnterpriseLicence && ((_assistantContextValu = assistantContextValue === null || assistantContextValue === void 0 ? void 0 : assistantContextValue.assistantAvailability.isAssistantEnabled) !== null && _assistantContextValu !== void 0 ? _assistantContextValu : false) && ((_assistantContextValu2 = assistantContextValue === null || assistantContextValue === void 0 ? void 0 : assistantContextValue.assistantAvailability.hasAssistantPrivilege) !== null && _assistantContextValu2 !== void 0 ? _assistantContextValu2 : false),
      httpFetch: http.fetch,
      toasts: notifications.toasts
    },
    params: {
      prompt_group_id: 'aiAssistant',
      prompt_ids: ['alertEvaluation', 'dataQualityAnalysis', 'ruleAnalysis', 'assetAnalysis']
    }
  });
  const promptContext = (0, _useObservable.default)(elasticAssistantSharedState.promptContexts.getPromptContext$(), {});
  (0, _react.useEffect)(() => {
    if ((0, _fp.isEmpty)(promptContext)) {
      elasticAssistantSharedState.promptContexts.setPromptContext(promptContexts);
    }
  }, [elasticAssistantSharedState.promptContexts, promptContext, promptContexts]);
  if (!assistantContextValue) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantProvider, {
    value: assistantContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_comment_actions_portal.CommentActionsPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_augment_message_code_blocks_portal.AugmentMessageCodeBlocksPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_migrate_conversation_from_local_storage.MigrateConversationsFromLocalStorage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), children);
};
exports.AssistantProvider = AssistantProvider;