"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventorySearchBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_refresh = require("@kbn/cloud-security-posture/src/hooks/use_refresh");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _kibana = require("../../common/lib/kibana");
var _filters_global = require("../../common/components/filters_global/filters_global");
var _data_view_context = require("../hooks/data_view_context");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/asset_inventory_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AssetInventorySearchBar = ({
  query,
  setQuery,
  placeholder = _i18n.i18n.translate('xpack.securitySolution.assetInventory.searchBar.searchPlaceholder', {
    defaultMessage: 'Filter your data using KQL syntax'
  }),
  isLoading
}) => {
  var _query$query, _query$query2;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    refresh,
    isRefreshing
  } = (0, _use_refresh.useRefresh)(_constants.QUERY_KEY_ASSET_INVENTORY);
  return /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      borderBottom: euiTheme.border.thin
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "Asset Inventory",
    showFilterBar: true,
    showQueryInput: true,
    showDatePicker: false,
    indexPatterns: [dataView],
    onQuerySubmit: (payload, isUpdated) => {
      if (isUpdated) {
        _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_SEARCH_QUERY_PERFORMED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
        setQuery(payload);
      } else {
        refresh();
      }
    },
    onFiltersUpdated: newFilters => setQuery({
      filters: newFilters
    }),
    placeholder: placeholder,
    query: {
      query: (query === null || query === void 0 ? void 0 : (_query$query = query.query) === null || _query$query === void 0 ? void 0 : _query$query.query) || '',
      language: (query === null || query === void 0 ? void 0 : (_query$query2 = query.query) === null || _query$query2 === void 0 ? void 0 : _query$query2.language) || 'kuery'
    },
    isLoading: isLoading || isRefreshing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  })));
};
exports.AssetInventorySearchBar = AssetInventorySearchBar;