"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _cellActions = require("@kbn/cell-actions");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _upselling_provider = require("../common/components/upselling_provider");
var _user_info = require("../detections/components/user_info");
var _constants = require("../../common/constants");
var _error_toast_dispatcher = require("../common/components/error_toast_dispatcher");
var _ml_capabilities_provider = require("../common/components/ml/permissions/ml_capabilities_provider");
var _toasters = require("../common/components/toasters");
var _kibana = require("../common/lib/kibana");
var _routes = require("./routes");
var _user_privileges_context = require("../common/components/user_privileges/user_privileges_context");
var _query_client_provider = require("../common/containers/query_client/query_client_provider");
var _provider = require("../common/components/discover_in_timeline/provider");
var _provider2 = require("../assistant/provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/app/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StartAppComponent = ({
  children,
  history,
  store,
  theme$
}) => {
  const services = (0, _kibana.useKibana)().services;
  const {
    application: {
      capabilities
    },
    uiActions,
    upselling
  } = services;
  const darkMode = (0, _public.useDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, services, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_toasters.ManageGlobalToaster, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_capabilities_provider.MlCapabilitiesProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: capabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_user_info.ManageUserInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
    core: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_upselling_provider.UpsellingProvider, {
    upsellingService: upselling,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_provider.DiscoverInTimelineContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_routes.PageRouter, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_provider2.AssistantProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 31
    }
  }, children))))))))))), /*#__PURE__*/_react.default.createElement(_error_toast_dispatcher.ErrorToastDispatcher, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_toasters.GlobalToaster, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
};
const StartApp = /*#__PURE__*/(0, _react.memo)(StartAppComponent);
const SecurityAppComponent = ({
  children,
  history,
  services,
  store,
  theme$
}) => {
  var _services$cloud$Cloud, _services$cloud;
  const CloudProvider = (_services$cloud$Cloud = (_services$cloud = services.cloud) === null || _services$cloud === void 0 ? void 0 : _services$cloud.CloudContextProvider) !== null && _services$cloud$Cloud !== void 0 ? _services$cloud$Cloud : _react.default.Fragment;
  return /*#__PURE__*/_react.default.createElement(_kibana.KibanaContextProvider, {
    services: {
      appName: _constants.APP_NAME,
      ...services
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StartApp, {
    history: history,
    store: store,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, children)));
};
const SecurityApp = exports.SecurityApp = /*#__PURE__*/(0, _react.memo)(SecurityAppComponent);