"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpsertRuleMigrationResourcesResponse = exports.UpsertRuleMigrationResourcesRequestParams = exports.UpsertRuleMigrationResourcesRequestBody = exports.UpdateRuleMigrationRulesResponse = exports.UpdateRuleMigrationRulesRequestParams = exports.UpdateRuleMigrationRulesRequestBody = exports.UpdateRuleMigrationRequestParams = exports.UpdateRuleMigrationRequestBody = exports.UpdateRuleMigrationIndexPatternResponse = exports.UpdateRuleMigrationIndexPatternRequestParams = exports.UpdateRuleMigrationIndexPatternRequestBody = exports.StopRuleMigrationResponse = exports.StopRuleMigrationRequestParams = exports.StartRuleMigrationResponse = exports.StartRuleMigrationRequestParams = exports.StartRuleMigrationRequestBody = exports.RuleMigrationEnhanceRuleResponse = exports.RuleMigrationEnhanceRuleRequestParams = exports.RuleMigrationEnhanceRuleRequestBody = exports.InstallMigrationRulesResponse = exports.InstallMigrationRulesRequestParams = exports.InstallMigrationRulesRequestBody = exports.GetRuleMigrationTranslationStatsResponse = exports.GetRuleMigrationTranslationStatsRequestParams = exports.GetRuleMigrationStatsResponse = exports.GetRuleMigrationStatsRequestParams = exports.GetRuleMigrationRulesResponse = exports.GetRuleMigrationRulesRequestQuery = exports.GetRuleMigrationRulesRequestParams = exports.GetRuleMigrationResponse = exports.GetRuleMigrationResourcesResponse = exports.GetRuleMigrationResourcesRequestQuery = exports.GetRuleMigrationResourcesRequestParams = exports.GetRuleMigrationResourcesMissingResponse = exports.GetRuleMigrationResourcesMissingRequestParams = exports.GetRuleMigrationRequestParams = exports.GetRuleMigrationPrivilegesResponse = exports.GetRuleMigrationPrebuiltRulesResponse = exports.GetRuleMigrationPrebuiltRulesRequestParams = exports.GetRuleMigrationIntegrationsStatsResponse = exports.GetRuleMigrationIntegrationsResponse = exports.GetAllStatsRuleMigrationResponse = exports.DeleteRuleMigrationRequestParams = exports.CreateRuleMigrationRulesRequestParams = exports.CreateRuleMigrationRulesRequestBody = exports.CreateRuleMigrationResponse = exports.CreateRuleMigrationRequestBody = exports.CreateQRadarRuleMigrationRulesRequestParams = exports.CreateQRadarRuleMigrationRulesRequestBody = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_migration = require("../../rule_migration.gen");
var _common_attributes = require("../../../../api/detection_engine/model/rule_schema/common_attributes.gen");
var _primitives = require("../../../../api/model/primitives.gen");
var _qradar = require("../../vendor/rules/qradar.gen");
var _common = require("../../common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: SIEM Rules Migration API
 *   version: 1
 */

const CreateQRadarRuleMigrationRulesRequestParams = exports.CreateQRadarRuleMigrationRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const CreateQRadarRuleMigrationRulesRequestBody = exports.CreateQRadarRuleMigrationRulesRequestBody = _zod.z.object({
  /**
   * The QRadar rules XML export content
   */
  xml: _zod.z.string().min(1)
});
const CreateRuleMigrationRequestBody = exports.CreateRuleMigrationRequestBody = _zod.z.object({
  /**
   * The rule migration name
   */
  name: _primitives.NonEmptyString
});
const CreateRuleMigrationResponse = exports.CreateRuleMigrationResponse = _zod.z.object({
  /**
   * The migration id created.
   */
  migration_id: _primitives.NonEmptyString
});
const CreateRuleMigrationRulesRequestParams = exports.CreateRuleMigrationRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const CreateRuleMigrationRulesRequestBody = exports.CreateRuleMigrationRulesRequestBody = _zod.z.array(_rule_migration.OriginalRule);
const DeleteRuleMigrationRequestParams = exports.DeleteRuleMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetAllStatsRuleMigrationResponse = exports.GetAllStatsRuleMigrationResponse = _zod.z.array(_rule_migration.RuleMigrationTaskStats);
const GetRuleMigrationRequestParams = exports.GetRuleMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetRuleMigrationResponse = exports.GetRuleMigrationResponse = _rule_migration.RuleMigration;

/**
 * The map of related integrations, with the integration id as a key
 */

const GetRuleMigrationIntegrationsResponse = exports.GetRuleMigrationIntegrationsResponse = _zod.z.object({}).catchall(_common_attributes.RelatedIntegration);
const GetRuleMigrationIntegrationsStatsResponse = exports.GetRuleMigrationIntegrationsStatsResponse = _rule_migration.RuleMigrationAllIntegrationsStats;
const GetRuleMigrationPrebuiltRulesRequestParams = exports.GetRuleMigrationPrebuiltRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});

/**
 * The map of prebuilt rules, with the rules id as a key
 */

const GetRuleMigrationPrebuiltRulesResponse = exports.GetRuleMigrationPrebuiltRulesResponse = _zod.z.object({}).catchall(_rule_migration.PrebuiltRuleVersion);

/**
 * The missing index privileges required for the migration
 */

const GetRuleMigrationPrivilegesResponse = exports.GetRuleMigrationPrivilegesResponse = _zod.z.array(_zod.z.object({
  /**
   * The index name of the privilege missing
   */
  indexName: _zod.z.string(),
  /**
   * The index privileges level missing
   */
  privileges: _zod.z.array(_zod.z.string())
}));
const GetRuleMigrationResourcesRequestQuery = exports.GetRuleMigrationResourcesRequestQuery = _zod.z.object({
  type: _common.SiemMigrationResourceType.optional(),
  names: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  from: _zod.z.coerce.number().optional(),
  size: _zod.z.coerce.number().optional()
});
const GetRuleMigrationResourcesRequestParams = exports.GetRuleMigrationResourcesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetRuleMigrationResourcesResponse = exports.GetRuleMigrationResourcesResponse = _zod.z.array(_common.SiemMigrationResource);
const GetRuleMigrationResourcesMissingRequestParams = exports.GetRuleMigrationResourcesMissingRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});

/**
 * The identified resources missing
 */

const GetRuleMigrationResourcesMissingResponse = exports.GetRuleMigrationResourcesMissingResponse = _zod.z.array(_common.SiemMigrationResourceBase);
const GetRuleMigrationRulesRequestQuery = exports.GetRuleMigrationRulesRequestQuery = _zod.z.object({
  page: _zod.z.coerce.number().optional(),
  per_page: _zod.z.coerce.number().optional(),
  sort_field: _primitives.NonEmptyString.optional(),
  sort_direction: _zod.z.enum(['asc', 'desc']).optional(),
  search_term: _zod.z.string().optional(),
  ids: (0, _zodHelpers.ArrayFromString)(_primitives.NonEmptyString).optional(),
  is_prebuilt: _zodHelpers.BooleanFromString.optional(),
  is_installed: _zodHelpers.BooleanFromString.optional(),
  is_fully_translated: _zodHelpers.BooleanFromString.optional(),
  is_partially_translated: _zodHelpers.BooleanFromString.optional(),
  is_untranslatable: _zodHelpers.BooleanFromString.optional(),
  is_failed: _zodHelpers.BooleanFromString.optional(),
  is_missing_index: _zodHelpers.BooleanFromString.optional()
});
const GetRuleMigrationRulesRequestParams = exports.GetRuleMigrationRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetRuleMigrationRulesResponse = exports.GetRuleMigrationRulesResponse = _zod.z.object({
  /**
   * The total number of rules in migration.
   */
  total: _zod.z.number(),
  data: _zod.z.array(_rule_migration.RuleMigrationRule)
});
const GetRuleMigrationStatsRequestParams = exports.GetRuleMigrationStatsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetRuleMigrationStatsResponse = exports.GetRuleMigrationStatsResponse = _rule_migration.RuleMigrationTaskStats;
const GetRuleMigrationTranslationStatsRequestParams = exports.GetRuleMigrationTranslationStatsRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const GetRuleMigrationTranslationStatsResponse = exports.GetRuleMigrationTranslationStatsResponse = _rule_migration.RuleMigrationTranslationStats;
const InstallMigrationRulesRequestParams = exports.InstallMigrationRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const InstallMigrationRulesRequestBody = exports.InstallMigrationRulesRequestBody = _zod.z.object({
  ids: _zod.z.array(_primitives.NonEmptyString).optional(),
  /**
   * Indicates whether installed rules should be enabled
   */
  enabled: _zod.z.boolean().optional()
});
const InstallMigrationRulesResponse = exports.InstallMigrationRulesResponse = _zod.z.object({
  /**
   * Indicates the number of successfully installed migration rules.
   */
  installed: _zod.z.number()
});
const RuleMigrationEnhanceRuleRequestParams = exports.RuleMigrationEnhanceRuleRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const RuleMigrationEnhanceRuleRequestBody = exports.RuleMigrationEnhanceRuleRequestBody = _qradar.EnhanceQRadarRule;

/**
 * Response from rule enhancement operation
 */

const RuleMigrationEnhanceRuleResponse = exports.RuleMigrationEnhanceRuleResponse = _zod.z.object({
  /**
   * whether the update was applied successfully
   */
  updated: _zod.z.boolean()
});
const StartRuleMigrationRequestParams = exports.StartRuleMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const StartRuleMigrationRequestBody = exports.StartRuleMigrationRequestBody = _zod.z.object({
  /**
   * Settings applicable to current rule migration task execution.
   */
  settings: _rule_migration.RuleMigrationTaskExecutionSettings,
  langsmith_options: _common.LangSmithOptions.optional(),
  /**
   * The optional indicator to retry the rule translation based on this filter criteria.
   */
  retry: _rule_migration.RuleMigrationRetryFilter.optional(),
  /**
   * Selected rules to retry migration on.
   */
  selection: _zod.z.object({
    ids: _zod.z.array(_primitives.NonEmptyString)
  }).optional()
});
const StartRuleMigrationResponse = exports.StartRuleMigrationResponse = _zod.z.object({
  /**
   * Indicates the migration has been started. `false` means the migration does not need to be started.
   */
  started: _zod.z.boolean()
});
const StopRuleMigrationRequestParams = exports.StopRuleMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const StopRuleMigrationResponse = exports.StopRuleMigrationResponse = _zod.z.object({
  /**
   * Indicates the migration has been stopped.
   */
  stopped: _zod.z.boolean()
});
const UpdateRuleMigrationRequestParams = exports.UpdateRuleMigrationRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpdateRuleMigrationRequestBody = exports.UpdateRuleMigrationRequestBody = _zod.z.object({
  /**
   * The rule migration name
   */
  name: _primitives.NonEmptyString.optional(),
  /**
   * The index pattern to update
   */
  index_pattern: _primitives.NonEmptyString.optional()
});
const UpdateRuleMigrationIndexPatternRequestParams = exports.UpdateRuleMigrationIndexPatternRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpdateRuleMigrationIndexPatternRequestBody = exports.UpdateRuleMigrationIndexPatternRequestBody = _zod.z.object({
  ids: _zod.z.array(_primitives.NonEmptyString).optional(),
  /**
   * The index pattern to update
   */
  index_pattern: _primitives.NonEmptyString
});
const UpdateRuleMigrationIndexPatternResponse = exports.UpdateRuleMigrationIndexPatternResponse = _zod.z.object({
  /**
   * Indicates the number of rules that have been updated.
   */
  updated: _zod.z.number()
});
const UpdateRuleMigrationRulesRequestParams = exports.UpdateRuleMigrationRulesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpdateRuleMigrationRulesRequestBody = exports.UpdateRuleMigrationRulesRequestBody = _zod.z.array(_rule_migration.UpdateRuleMigrationRule);
const UpdateRuleMigrationRulesResponse = exports.UpdateRuleMigrationRulesResponse = _zod.z.object({
  /**
   * Indicates rules migrations have been updated.
   */
  updated: _zod.z.boolean()
});
const UpsertRuleMigrationResourcesRequestParams = exports.UpsertRuleMigrationResourcesRequestParams = _zod.z.object({
  migration_id: _primitives.NonEmptyString
});
const UpsertRuleMigrationResourcesRequestBody = exports.UpsertRuleMigrationResourcesRequestBody = _zod.z.array(_common.SiemMigrationResourceData);
const UpsertRuleMigrationResourcesResponse = exports.UpsertRuleMigrationResourcesResponse = _zod.z.object({
  /**
   * The request has been processed correctly.
   */
  acknowledged: _zod.z.boolean()
});