"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationTaskStatus = exports.SiemMigrationStatus = exports.SiemMigrationRetryFilter = exports.SIEM_RULE_MIGRATION_UPDATE_INDEX_PATTERN_PATH = exports.SIEM_RULE_MIGRATION_TRANSLATION_STATS_PATH = exports.SIEM_RULE_MIGRATION_STOP_PATH = exports.SIEM_RULE_MIGRATION_STATS_PATH = exports.SIEM_RULE_MIGRATION_START_PATH = exports.SIEM_RULE_MIGRATION_RULES_PATH = exports.SIEM_RULE_MIGRATION_RULES_ENHANCE_PATH = exports.SIEM_RULE_MIGRATION_RESOURCES_PATH = exports.SIEM_RULE_MIGRATION_RESOURCES_MISSING_PATH = exports.SIEM_RULE_MIGRATION_QRADAR_RULES_PATH = exports.SIEM_RULE_MIGRATION_PATH = exports.SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH = exports.SIEM_RULE_MIGRATION_INSTALL_PATH = exports.SIEM_RULE_MIGRATION_INDEX_PATTERN_PLACEHOLDER = exports.SIEM_RULE_MIGRATION_EVALUATE_PATH = exports.SIEM_RULE_MIGRATIONS_PREBUILT_RULES_PATH = exports.SIEM_RULE_MIGRATIONS_PATH = exports.SIEM_RULE_MIGRATIONS_INTEGRATIONS_STATS_PATH = exports.SIEM_RULE_MIGRATIONS_INTEGRATIONS_PATH = exports.SIEM_RULE_MIGRATIONS_ALL_STATS_PATH = exports.SIEM_MIGRATIONS_PATH = exports.SIEM_MIGRATIONS_ASSISTANT_USER = exports.MigrationTranslationResult = exports.LOOKUPS_INDEX_PREFIX = exports.DEFAULT_TRANSLATION_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIEM_MIGRATIONS_ASSISTANT_USER = exports.SIEM_MIGRATIONS_ASSISTANT_USER = 'assistant';
const SIEM_MIGRATIONS_PATH = exports.SIEM_MIGRATIONS_PATH = '/internal/siem_migrations';

// TODO: Move `SIEM_RULE_MIGRATIONS_PATH` and composed paths to rules/constants.ts
const SIEM_RULE_MIGRATIONS_PATH = exports.SIEM_RULE_MIGRATIONS_PATH = `${SIEM_MIGRATIONS_PATH}/rules`;
const SIEM_RULE_MIGRATIONS_ALL_STATS_PATH = exports.SIEM_RULE_MIGRATIONS_ALL_STATS_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/stats`;
const SIEM_RULE_MIGRATIONS_INTEGRATIONS_PATH = exports.SIEM_RULE_MIGRATIONS_INTEGRATIONS_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/integrations`;
const SIEM_RULE_MIGRATIONS_INTEGRATIONS_STATS_PATH = exports.SIEM_RULE_MIGRATIONS_INTEGRATIONS_STATS_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/integrations/stats`;
const SIEM_RULE_MIGRATION_PATH = exports.SIEM_RULE_MIGRATION_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/{migration_id}`;
const SIEM_RULE_MIGRATION_RULES_PATH = exports.SIEM_RULE_MIGRATION_RULES_PATH = `${SIEM_RULE_MIGRATION_PATH}/rules`;
const SIEM_RULE_MIGRATION_RULES_ENHANCE_PATH = exports.SIEM_RULE_MIGRATION_RULES_ENHANCE_PATH = `${SIEM_RULE_MIGRATION_RULES_PATH}/enhance`;
const SIEM_RULE_MIGRATION_QRADAR_RULES_PATH = exports.SIEM_RULE_MIGRATION_QRADAR_RULES_PATH = `${SIEM_RULE_MIGRATION_PATH}/qradar/rules`;
const SIEM_RULE_MIGRATION_START_PATH = exports.SIEM_RULE_MIGRATION_START_PATH = `${SIEM_RULE_MIGRATION_PATH}/start`;
const SIEM_RULE_MIGRATION_UPDATE_INDEX_PATTERN_PATH = exports.SIEM_RULE_MIGRATION_UPDATE_INDEX_PATTERN_PATH = `${SIEM_RULE_MIGRATION_PATH}/update_index_pattern`;
const SIEM_RULE_MIGRATION_STATS_PATH = exports.SIEM_RULE_MIGRATION_STATS_PATH = `${SIEM_RULE_MIGRATION_PATH}/stats`;
const SIEM_RULE_MIGRATION_TRANSLATION_STATS_PATH = exports.SIEM_RULE_MIGRATION_TRANSLATION_STATS_PATH = `${SIEM_RULE_MIGRATION_PATH}/translation_stats`;
const SIEM_RULE_MIGRATION_STOP_PATH = exports.SIEM_RULE_MIGRATION_STOP_PATH = `${SIEM_RULE_MIGRATION_PATH}/stop`;
const SIEM_RULE_MIGRATION_INSTALL_PATH = exports.SIEM_RULE_MIGRATION_INSTALL_PATH = `${SIEM_RULE_MIGRATION_PATH}/install`;
const SIEM_RULE_MIGRATIONS_PREBUILT_RULES_PATH = exports.SIEM_RULE_MIGRATIONS_PREBUILT_RULES_PATH = `${SIEM_RULE_MIGRATION_PATH}/prebuilt_rules`;
const SIEM_RULE_MIGRATION_RESOURCES_PATH = exports.SIEM_RULE_MIGRATION_RESOURCES_PATH = `${SIEM_RULE_MIGRATION_PATH}/resources`;
const SIEM_RULE_MIGRATION_RESOURCES_MISSING_PATH = exports.SIEM_RULE_MIGRATION_RESOURCES_MISSING_PATH = `${SIEM_RULE_MIGRATION_RESOURCES_PATH}/missing`;
const SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH = exports.SIEM_RULE_MIGRATION_MISSING_PRIVILEGES_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/missing_privileges`;
const SIEM_RULE_MIGRATION_EVALUATE_PATH = exports.SIEM_RULE_MIGRATION_EVALUATE_PATH = `${SIEM_RULE_MIGRATIONS_PATH}/evaluate`;
const LOOKUPS_INDEX_PREFIX = exports.LOOKUPS_INDEX_PREFIX = 'lookup_';
let SiemMigrationTaskStatus = exports.SiemMigrationTaskStatus = /*#__PURE__*/function (SiemMigrationTaskStatus) {
  SiemMigrationTaskStatus["READY"] = "ready";
  SiemMigrationTaskStatus["RUNNING"] = "running";
  SiemMigrationTaskStatus["STOPPED"] = "stopped";
  SiemMigrationTaskStatus["INTERRUPTED"] = "interrupted";
  SiemMigrationTaskStatus["FINISHED"] = "finished";
  return SiemMigrationTaskStatus;
}({});
let SiemMigrationStatus = exports.SiemMigrationStatus = /*#__PURE__*/function (SiemMigrationStatus) {
  SiemMigrationStatus["PENDING"] = "pending";
  SiemMigrationStatus["PROCESSING"] = "processing";
  SiemMigrationStatus["COMPLETED"] = "completed";
  SiemMigrationStatus["FAILED"] = "failed";
  return SiemMigrationStatus;
}({});
let SiemMigrationRetryFilter = exports.SiemMigrationRetryFilter = /*#__PURE__*/function (SiemMigrationRetryFilter) {
  SiemMigrationRetryFilter["FAILED"] = "failed";
  SiemMigrationRetryFilter["NOT_FULLY_TRANSLATED"] = "not_fully_translated";
  return SiemMigrationRetryFilter;
}({});
let MigrationTranslationResult = exports.MigrationTranslationResult = /*#__PURE__*/function (MigrationTranslationResult) {
  MigrationTranslationResult["FULL"] = "full";
  MigrationTranslationResult["PARTIAL"] = "partial";
  MigrationTranslationResult["UNTRANSLATABLE"] = "untranslatable";
  return MigrationTranslationResult;
}({});
const DEFAULT_TRANSLATION_FIELDS = exports.DEFAULT_TRANSLATION_FIELDS = {
  from: 'now-360s',
  to: 'now',
  interval: '5m'
};
const SIEM_RULE_MIGRATION_INDEX_PATTERN_PLACEHOLDER = exports.SIEM_RULE_MIGRATION_INDEX_PATTERN_PLACEHOLDER = '[indexPattern]';