"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseLocationState = exports.AIValueReportLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _zod = require("@kbn/zod");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AIValueReportParamsSchema = _zod.z.object({
  timeRange: _zod.z.object({
    to: _zod.z.string().nonempty(),
    from: _zod.z.string().nonempty()
  }),
  insight: _zod.z.string().nonempty(),
  reportDataHash: _zod.z.string().nonempty()
});
class AIValueReportLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", _deeplinksAnalytics.AI_VALUE_REPORT_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      return {
        app: _constants.APP_UI_ID,
        path: _constants.AI_VALUE_PATH,
        state: params
      };
    });
  }
}
exports.AIValueReportLocatorDefinition = AIValueReportLocatorDefinition;
const parseLocationState = state => {
  const result = AIValueReportParamsSchema.passthrough().safeParse(state);
  if (result.error) {
    // This will cause the page to fallback to rendering normally
    return undefined;
  }
  return result.data;
};
exports.parseLocationState = parseLocationState;