"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerRiskScoreCalculationResponse = exports.TriggerRiskScoreCalculationRequestBody = exports.RiskScoresEntityCalculationResponse = exports.RiskScoresEntityCalculationRequest = exports.DeprecatedTriggerRiskScoreCalculationResponse = exports.DeprecatedTriggerRiskScoreCalculationRequestBody = void 0;
var _zod = require("@kbn/zod");
var _common = require("../common/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Risk Scoring API
 *   version: 1
 */

const RiskScoresEntityCalculationRequest = exports.RiskScoresEntityCalculationRequest = _zod.z.object({
  /**
   * Used to identify the entity.
   */
  identifier: _zod.z.string(),
  /**
   * Used to define the type of entity.
   */
  identifier_type: _common.IdentifierType,
  /**
   * If 'wait_for' the request will wait for the index refresh.
   */
  refresh: _zod.z.literal('wait_for').optional()
});
const RiskScoresEntityCalculationResponse = exports.RiskScoresEntityCalculationResponse = _zod.z.object({
  success: _zod.z.boolean(),
  score: _common.EntityRiskScoreRecord.optional()
});
const DeprecatedTriggerRiskScoreCalculationRequestBody = exports.DeprecatedTriggerRiskScoreCalculationRequestBody = RiskScoresEntityCalculationRequest;
const DeprecatedTriggerRiskScoreCalculationResponse = exports.DeprecatedTriggerRiskScoreCalculationResponse = RiskScoresEntityCalculationResponse;
const TriggerRiskScoreCalculationRequestBody = exports.TriggerRiskScoreCalculationRequestBody = RiskScoresEntityCalculationRequest;
const TriggerRiskScoreCalculationResponse = exports.TriggerRiskScoreCalculationResponse = RiskScoresEntityCalculationResponse;