"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserName = exports.MonitoringLabel = exports.MonitoredUserUpdateDoc = exports.MonitoredUserDoc = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Privilege Monitoring Users Common Schema
 *   version: 1
 */

const UserName = exports.UserName = _zod.z.object({
  user: _zod.z.object({
    /**
     * The name of the user.
     */
    name: _zod.z.string().optional()
  }).optional(),
  /**
   * Entity analytics monitoring configuration for the user
   */
  entity_analytics_monitoring: _zod.z.object({
    /**
     * Array of labels associated with the user
     */
    labels: _zod.z.array(_zod.z.object({
      /**
       * The field name for the label
       */
      field: _zod.z.string().optional(),
      /**
       * The value of the label
       */
      value: _zod.z.string().optional(),
      /**
       * The source where this label was created (api, csv, or index_sync)
       */
      source: _zod.z.enum(['api', 'csv', 'index_sync']).optional()
    })).optional()
  }).optional()
});
const MonitoringLabel = exports.MonitoringLabel = _zod.z.object({
  field: _zod.z.string(),
  value: _zod.z.string(),
  source: _zod.z.string()
});
const MonitoredUserUpdateDoc = exports.MonitoredUserUpdateDoc = _zod.z.object({
  id: _zod.z.string().optional(),
  user: _zod.z.object({
    name: _zod.z.string().optional(),
    /**
     * Indicates if the user is privileged.
     */
    is_privileged: _zod.z.boolean().optional()
  }).optional(),
  labels: _zod.z.object({
    sources: _zod.z.array(_zod.z.unknown()).optional(),
    source_ids: _zod.z.array(_zod.z.string()).optional(),
    source_integrations: _zod.z.array(_zod.z.string()).optional()
  }).optional(),
  entity_analytics_monitoring: _zod.z.object({
    labels: _zod.z.array(MonitoringLabel).optional()
  }).optional()
});
const MonitoredUserDoc = exports.MonitoredUserDoc = MonitoredUserUpdateDoc.merge(_zod.z.object({
  event: _zod.z.object({
    ingested: _zod.z.string().datetime().optional(),
    '@timestamp': _zod.z.string().datetime().optional()
  }).optional(),
  '@timestamp': _zod.z.string().datetime().optional(),
  user: _zod.z.object({
    name: _zod.z.string().optional(),
    /**
     * Indicates if the user is privileged.
     */
    is_privileged: _zod.z.boolean().optional(),
    entity: _zod.z.object({
      attributes: _zod.z.object({
        /**
         * Indicates if the user is privileged.
         */
        Privileged: _zod.z.boolean().optional()
      }).optional()
    }).optional()
  }).optional()
}));