"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateScriptRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../endpoint/constants");
var _schema_utils = require("../schema_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateScriptRequestSchema = exports.CreateScriptRequestSchema = {
  body: _configSchema.schema.object({
    name: _configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    }),
    platform: _configSchema.schema.arrayOf(
    // @ts-expect-error TS2769: No overload matches this call. (due to now `oneOf()` type is defined)
    _configSchema.schema.oneOf(_constants.SUPPORTED_HOST_OS_TYPE.map(osType => _configSchema.schema.literal(osType))), {
      minSize: 1,
      maxSize: 3,
      validate: _schema_utils.validateNoDuplicateValues
    }),
    file: _configSchema.schema.stream(),
    requiresInput: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false
    })),
    description: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    })),
    instructions: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    })),
    example: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    })),
    pathToExecutable: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: 1,
      validate: _schema_utils.validateNonEmptyString
    }))
  })
};