"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithOutputs = exports.UserIds = exports.Types = exports.TypeEnum = exports.Type = exports.Timeout = exports.SuccessResponse = exports.Statuses = exports.StatusEnum = exports.Status = exports.StartDate = exports.SortFieldEnum = exports.SortField = exports.SortDirectionEnum = exports.SortDirection = exports.ResponseActionDetails = exports.ResponseActionCreateSuccessResponse = exports.ProtectionUpdatesNoteResponse = exports.Parameters = exports.PageSize = exports.Page = exports.NoParametersRequestSchema = exports.Kuery = exports.IdOrUndefined = exports.Id = exports.HostStatuses = exports.EndpointIds = exports.EndDate = exports.Comment = exports.Commands = exports.CommandEnum = exports.Command = exports.BaseActionSchema = exports.AgentTypesEnum = exports.AgentTypes = exports.AgentIds = exports.AgentId = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Endpoint Attributes
 *   version: 2023-10-31
 */

const Id = exports.Id = _zod.z.string();
const IdOrUndefined = exports.IdOrUndefined = Id.nullable();

/**
 * Page number
 */

const Page = exports.Page = _zod.z.number().int().min(1).default(1);

/**
 * Number of items per page
 */

const PageSize = exports.PageSize = _zod.z.number().int().min(1).max(100).default(10);

/**
 * A start date in ISO 8601 format or Date Math format.
 */

const StartDate = exports.StartDate = _zod.z.string();

/**
 * An end date in ISO format or Date Math format.
 */

const EndDate = exports.EndDate = _zod.z.string();

/**
 * Agent ID
 */

const AgentId = exports.AgentId = _zod.z.string();

/**
 * A KQL string.
 */

const Kuery = exports.Kuery = _zod.z.string();

/**
 * A set of agent health statuses to filter by.
 */

const HostStatuses = exports.HostStatuses = _zod.z.array(_zod.z.enum(['healthy', 'offline', 'updating', 'inactive', 'unenrolled']));

/**
 * Determines the sort order.
 */

const SortDirection = exports.SortDirection = _zod.z.enum(['asc', 'desc']);
const SortDirectionEnum = exports.SortDirectionEnum = SortDirection.enum;

/**
 * Determines which field is used to sort the results.
 */

const SortField = exports.SortField = _zod.z.enum(['enrolled_at', 'metadata.host.hostname', 'host_status', 'metadata.Endpoint.policy.applied.name', 'metadata.Endpoint.policy.applied.status', 'metadata.host.os.name', 'metadata.host.ip', 'metadata.agent.version', 'last_checkin']);
const SortFieldEnum = exports.SortFieldEnum = SortField.enum;

/**
 * A list of agent IDs. Max of 50.
 */

const AgentIds = exports.AgentIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1).max(50), _zod.z.string().min(1)]);

/**
 * The command for the response action
 */

const Command = exports.Command = _zod.z.enum(['isolate', 'unisolate', 'kill-process', 'suspend-process', 'running-processes', 'get-file', 'execute', 'upload', 'scan', 'runscript', 'cancel']);
const CommandEnum = exports.CommandEnum = Command.enum;

/**
 * A list of response action command names.
 */

const Commands = exports.Commands = _zod.z.array(Command);

/**
 * The maximum timeout value in milliseconds (optional)
 */

const Timeout = exports.Timeout = _zod.z.number().int().min(1);
const Status = exports.Status = _zod.z.enum(['failed', 'pending', 'successful']);
const StatusEnum = exports.StatusEnum = Status.enum;
const Statuses = exports.Statuses = _zod.z.array(Status);

/**
 * A list of user IDs.
 */

const UserIds = exports.UserIds = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);

/**
 * A list of action IDs that should include the complete output of the action.
 */

const WithOutputs = exports.WithOutputs = _zod.z.union([_zod.z.array(_zod.z.string().min(1)).min(1), _zod.z.string().min(1)]);

/**
 * Type of response action
 */

const Type = exports.Type = _zod.z.enum(['automated', 'manual']);
const TypeEnum = exports.TypeEnum = Type.enum;

/**
 * List of types of response actions
 */

const Types = exports.Types = _zod.z.array(Type);

/**
 * List of endpoint IDs (cannot contain empty strings)
 */

const EndpointIds = exports.EndpointIds = _zod.z.array(_zod.z.string().min(1)).min(1);

/**
 * Optional comment
 */

const Comment = exports.Comment = _zod.z.string();

/**
 * Optional parameters object
 */

const Parameters = exports.Parameters = _zod.z.object({});

/**
 * List of agent types to retrieve. Defaults to `endpoint`.
 */

const AgentTypes = exports.AgentTypes = _zod.z.enum(['endpoint', 'sentinel_one', 'crowdstrike', 'microsoft_defender_endpoint']);
const AgentTypesEnum = exports.AgentTypesEnum = AgentTypes.enum;
const BaseActionSchema = exports.BaseActionSchema = _zod.z.object({
  endpoint_ids: EndpointIds,
  /**
   * If this action is associated with any alerts, they can be specified here. The action will be logged in any cases associated with the specified alerts.
   */
  alert_ids: _zod.z.array(_zod.z.string().min(1)).min(1).optional(),
  /**
   * The IDs of cases where the action taken will be logged.
   */
  case_ids: _zod.z.array(_zod.z.string().min(1)).min(1).optional(),
  comment: Comment.optional(),
  parameters: Parameters.optional(),
  agent_type: AgentTypes.optional()
});
const NoParametersRequestSchema = exports.NoParametersRequestSchema = _zod.z.object({
  body: BaseActionSchema
});
const ProtectionUpdatesNoteResponse = exports.ProtectionUpdatesNoteResponse = _zod.z.object({
  note: _zod.z.string().optional()
});
const ResponseActionDetails = exports.ResponseActionDetails = _zod.z.object({
  /**
   * The response action ID
   */
  id: _zod.z.string().uuid().optional(),
  command: Command,
  agentType: AgentTypes.optional(),
  /**
   * Whether the response action is expired
   */
  isExpired: _zod.z.boolean().optional(),
  /**
   * Whether the response action is complete
   */
  isComplete: _zod.z.boolean().optional(),
  /**
   * Whether the response action was successful
   */
  wasSuccessful: _zod.z.boolean().optional(),
  /**
   * The response action status
   */
  status: _zod.z.string().optional(),
  /**
   * The response action start time
   */
  startedAt: _zod.z.string().datetime().optional(),
  /**
   * The response action completion time
   */
  completedAt: _zod.z.string().datetime().optional(),
  /**
   * The user who created the response action
   */
  createdBy: _zod.z.string().optional(),
  /**
   * The agent IDs for the hosts that the response action was sent to
   */
  agents: _zod.z.array(_zod.z.string().uuid()).optional(),
  /**
   * The parameters of the response action. Content different depending on the response action command
   */
  parameters: _zod.z.object({}).optional(),
  /**
   * An object containing the host names associated with the agent IDs the response action was sent to
   */
  hosts: _zod.z.object({}).catchall(_zod.z.object({
    /**
     * The host name
     */
    name: _zod.z.string().optional()
  })).optional(),
  /**
   * The state of the response action for each agent ID that it was sent to
   */
  agentState: _zod.z.object({}).catchall(_zod.z.object({
    /**
     * Whether the response action is completed for the agent ID
     */
    isCompleted: _zod.z.boolean().optional(),
    /**
     * Whether the response action was successful for the agent ID
     */
    wasSuccessful: _zod.z.boolean().optional(),
    /**
     * The date and time the response action was completed for the agent ID
     */
    completedAt: _zod.z.string().optional()
  })).optional(),
  /** 
      * The outputs of the response action for each agent ID that it was sent to. Content different depending on the
  response action command and will only be present for agents that have responded to the response action
        */
  outputs: _zod.z.object({}).catchall(_zod.z.object({
    type: _zod.z.enum(['json', 'text']),
    /**
     * The response action output content for the agent ID. Exact format depends on the response action command.
     */
    content: _zod.z.union([_zod.z.object({}), _zod.z.string()])
  })).optional()
});
const ResponseActionCreateSuccessResponse = exports.ResponseActionCreateSuccessResponse = _zod.z.object({
  data: ResponseActionDetails.optional()
});
const SuccessResponse = exports.SuccessResponse = _zod.z.object({});