"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRulesNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
var _i18n_strings = require("../i18n_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createRulesNavigationTree = () => ({
  id: _constants.SecurityGroupName.rules,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.rules].title,
  icon: 'securitySignal',
  renderAs: 'panelOpener',
  children: [{
    title: _i18n_strings.i18nStrings.rules.management.title,
    breadcrumbStatus: 'hidden',
    children: [{
      id: _constants.SecurityPageName.rules,
      link: (0, _links.securityLink)(_constants.SecurityPageName.rules),
      children: [{
        id: _constants.SecurityPageName.rulesManagement,
        link: (0, _links.securityLink)(_constants.SecurityPageName.rulesManagement)
      }, {
        id: _constants.SecurityPageName.rulesAdd,
        link: (0, _links.securityLink)(_constants.SecurityPageName.rulesAdd)
      }, {
        id: _constants.SecurityPageName.rulesCreate,
        link: (0, _links.securityLink)(_constants.SecurityPageName.rulesCreate)
      }]
    }, {
      id: _constants.SecurityPageName.cloudSecurityPostureBenchmarks,
      link: (0, _links.securityLink)(_constants.SecurityPageName.cloudSecurityPostureBenchmarks)
    }, {
      id: _constants.SecurityPageName.exceptions,
      link: (0, _links.securityLink)(_constants.SecurityPageName.exceptions)
    }]
  }, {
    title: _i18n_strings.i18nStrings.rules.management.discover,
    breadcrumbStatus: 'hidden',
    children: [{
      id: _constants.SecurityPageName.coverageOverview,
      link: (0, _links.securityLink)(_constants.SecurityPageName.coverageOverview)
    }]
  }]
});
exports.createRulesNavigationTree = createRulesNavigationTree;