"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInvestigationsNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createInvestigationsNavigationTree = () => ({
  id: _constants.SecurityGroupName.investigations,
  icon: 'inspect',
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.investigations].title,
  renderAs: 'panelOpener',
  children: [{
    id: _constants.SecurityPageName.timelines,
    link: (0, _links.securityLink)(_constants.SecurityPageName.timelines),
    children: [{
      id: _constants.SecurityPageName.timelinesTemplates,
      link: (0, _links.securityLink)(_constants.SecurityPageName.timelinesTemplates)
    }]
  }, {
    id: _constants.SecurityPageName.notes,
    link: (0, _links.securityLink)(_constants.SecurityPageName.notes)
  }, {
    link: 'osquery'
  }]
});
exports.createInvestigationsNavigationTree = createInvestigationsNavigationTree;