"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPrivilegeForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _lodash = _interopRequireDefault(require("lodash"));
var _react2 = _interopRequireWildcard(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _remote_clusters_combo_box = require("./remote_clusters_combo_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/index_privilege_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fromOption = option => option.label;
const toOption = value => ({
  label: value
});
class IndexPrivilegeForm extends _react2.Component {
  constructor(props) {
    super(props);
    // This is distinct from the field within `this.state`.
    // We want to make sure that only one request for fields is in-flight at a time,
    // and relying on state for this is error prone.
    (0, _defineProperty2.default)(this, "isFieldListLoading", false);
    (0, _defineProperty2.default)(this, "getPrivilegeForm", () => {
      var _this$props$remoteClu;
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGrid, {
        css: (0, _react.css)`
            grid-template-columns: repeat(
              ${this.props.indexType === 'remote_indices' ? 3 : 2},
              minmax(0, 1fr)
            );
            @media (max-width: ${_uiTheme.euiThemeVars.euiBreakpoints.s}px) {
              grid-template-columns: repeat(1, minmax(0, 1fr));
            }
          `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 9
        }
      }, this.props.indexType === 'remote_indices' ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.clustersFormRowLabel",
          defaultMessage: "Remote clusters",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 148,
            columnNumber: 19
          }
        }),
        fullWidth: true
      }, this.props.validator.validateRemoteIndexPrivilegeClustersField(this.props.indexPrivilege), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react2.default.createElement(_remote_clusters_combo_box.RemoteClusterComboBox, {
        "data-test-subj": `clustersInput${this.props.formIndex}`,
        selectedOptions: ('clusters' in this.props.indexPrivilege && this.props.indexPrivilege.clusters ? this.props.indexPrivilege.clusters : []).map(toOption),
        onCreateOption: this.onCreateClusterOption,
        onChange: this.onClustersChange,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.clustersPlaceholder', {
          defaultMessage: 'Add a remote cluster…'
        }),
        remoteClusters: (_this$props$remoteClu = this.props.remoteClusters) !== null && _this$props$remoteClu !== void 0 ? _this$props$remoteClu : [],
        type: "remote_indexes",
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 17
        }
      }))) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: this.props.indexType === 'remote_indices' ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.remoteIndicesFormRowLabel",
          defaultMessage: "Remote indices",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 19
          }
        }) : /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.indicesFormRowLabel",
          defaultMessage: "Indices",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 19
          }
        }),
        fullWidth: true
      }, this.props.validator.validateIndexPrivilegeNamesField(this.props.indexPrivilege), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `indicesInput${this.props.formIndex}`,
        options: this.props.indexPatterns.map(toOption),
        selectedOptions: this.props.indexPrivilege.names.map(toOption),
        onCreateOption: this.onCreateIndexPatternOption,
        onChange: this.onIndexPatternsChange,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.indicesPlaceholder', {
          defaultMessage: 'Add an index pattern…'
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.privilegesFormRowLabel",
          defaultMessage: "Privileges",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 215,
            columnNumber: 17
          }
        }),
        fullWidth: true
      }, this.props.validator.validateIndexPrivilegePrivilegesField(this.props.indexPrivilege), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `privilegesInput${this.props.formIndex}`,
        options: this.props.availableIndexPrivileges.map(toOption),
        selectedOptions: this.props.indexPrivilege.privileges.map(toOption),
        onChange: this.onPrivilegeChange,
        onCreateOption: this.onCreateCustomPrivilege,
        isDisabled: this.props.isRoleReadOnly,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.privilegesPlaceholder', {
          defaultMessage: 'Add a privilege…'
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 15
        }
      })))), this.getFieldLevelControls(), this.getGrantedDocumentsControl());
    });
    (0, _defineProperty2.default)(this, "loadFLSOptions", (indexNames, force = false) => {
      if (this.props.indexType === 'remote_indices' || !force && (this.isFieldListLoading || indexNames.length === 0)) {
        return;
      }
      this.isFieldListLoading = true;
      this.setState({
        isFieldListLoading: true
      });
      this.props.indicesAPIClient.getFields(indexNames.join(',')).then(fields => {
        this.isFieldListLoading = false;
        this.setState({
          flsOptions: fields,
          isFieldListLoading: false
        });
      }).catch(() => {
        this.isFieldListLoading = false;
        this.setState({
          flsOptions: [],
          isFieldListLoading: false
        });
      });
    });
    (0, _defineProperty2.default)(this, "getFieldLevelControls", () => {
      const {
        allowFieldLevelSecurity,
        indexPrivilege,
        isRoleReadOnly
      } = this.props;
      const {
        grant,
        except
      } = this.getFieldSecurity(indexPrivilege);
      if (!allowFieldLevelSecurity) {
        return null;
      }
      if (isRoleReadOnly && !this.state.fieldSecurityExpanded) {
        return null;
      }
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 9
        }
      }, !isRoleReadOnly && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 290,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": `restrictFieldsQuery${this.props.formIndex}`,
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantFieldPrivilegesLabel",
          defaultMessage: "Grant access to specific fields",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 21
          }
        }),
        compressed: true,
        checked: this.state.fieldSecurityExpanded,
        onChange: this.toggleFieldSecurity,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 17
        }
      })), this.state.fieldSecurityExpanded && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 309,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 310,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantedFieldsFormRowLabel",
          defaultMessage: "Granted fields",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 313,
            columnNumber: 23
          }
        }),
        fullWidth: true,
        className: "indexPrivilegeForm__grantedFieldsRow",
        helpText: !isRoleReadOnly && grant.length === 0 ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.grantedFieldsFormRowHelpText",
          defaultMessage: "If no fields are granted, then users assigned to this role will not be able to see any data for this index.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 322,
            columnNumber: 25
          }
        }) : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `fieldInput${this.props.formIndex}`,
        options: this.state.flsOptions.map(toOption),
        selectedOptions: grant.map(toOption),
        onCreateOption: this.onCreateGrantedField,
        onChange: this.onGrantedFieldsChange,
        isDisabled: this.props.isRoleReadOnly,
        async: true,
        isLoading: this.state.isFieldListLoading,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.fieldPlaceholder', {
          defaultMessage: 'Add a field pattern…'
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 21
        }
      }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 346,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRoles.indexPrivilegeForm.deniedFieldsFormRowLabel",
          defaultMessage: "Denied fields",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 349,
            columnNumber: 23
          }
        }),
        fullWidth: true,
        className: "indexPrivilegeForm__deniedFieldsRow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
        "data-test-subj": `deniedFieldInput${this.props.formIndex}`,
        options: this.state.flsOptions.map(toOption),
        selectedOptions: except.map(toOption),
        onCreateOption: this.onCreateDeniedField,
        onChange: this.onDeniedFieldsChange,
        isDisabled: isRoleReadOnly,
        async: true,
        isLoading: this.state.isFieldListLoading,
        placeholder: _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deniedFieldPlaceholder', {
          defaultMessage: 'Add a field pattern…'
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 21
        }
      })))))));
    });
    (0, _defineProperty2.default)(this, "getGrantedDocumentsControl", () => {
      var _indexPrivilege$query;
      const {
        allowDocumentLevelSecurity,
        indexPrivilege,
        isRoleReadOnly
      } = this.props;
      if (!allowDocumentLevelSecurity) {
        return null;
      }
      if (this.props.isRoleReadOnly && !this.state.queryExpanded) {
        return null;
      }
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 395,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 9
        }
      }, !this.props.isRoleReadOnly && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": `restrictDocumentsQuery${this.props.formIndex}`,
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.grantReadPrivilegesLabel",
          defaultMessage: "Grant read privileges to specific documents",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 402,
            columnNumber: 19
          }
        }),
        compressed: true,
        checked: this.state.queryExpanded,
        onChange: this.toggleDocumentQuery,
        disabled: isRoleReadOnly,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 399,
          columnNumber: 15
        }
      })), this.state.queryExpanded && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 415,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.editRole.indexPrivilegeForm.grantedDocumentsQueryFormRowLabel",
          defaultMessage: "Granted documents query",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 418,
            columnNumber: 19
          }
        }),
        fullWidth: true,
        "data-test-subj": `queryInput${this.props.formIndex}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 416,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react2.default.createElement(_codeEditor.CodeEditorField, {
        languageId: "xjson",
        width: "100%",
        fullWidth: true,
        height: this.state.documentQueryEditorHeight,
        "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.grantedDocumentsQueryEditorAriaLabel', {
          defaultMessage: 'Granted documents query editor'
        }),
        value: (_indexPrivilege$query = indexPrivilege.query) !== null && _indexPrivilege$query !== void 0 ? _indexPrivilege$query : '',
        onChange: this.onQueryChange,
        options: {
          readOnly: this.props.isRoleReadOnly,
          minimap: {
            enabled: false
          },
          // Prevent an empty form from showing an error
          renderValidationDecorations: indexPrivilege.query ? 'editable' : 'off'
        },
        editorDidMount: this.editorDidMount,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 17
        }
      })))));
    });
    (0, _defineProperty2.default)(this, "editorDidMount", editor => {
      /**
       * Resize the editor based on the contents of the editor itself.
       * Adapted from https://github.com/microsoft/monaco-editor/issues/794#issuecomment-688959283
       */

      const minHeight = 100;
      const maxHeight = 1000;
      const updateHeight = () => {
        const contentHeight = Math.min(maxHeight, Math.max(minHeight, editor.getContentHeight()));
        this.setState({
          documentQueryEditorHeight: `${contentHeight}px`
        });
      };
      editor.onDidContentSizeChange(updateHeight);
      updateHeight();
    });
    (0, _defineProperty2.default)(this, "toggleDocumentQuery", () => {
      const willToggleOff = this.state.queryExpanded;
      const willToggleOn = !willToggleOff;

      // If turning off, then save the current query in state so that we can restore it if the user changes their mind.
      this.setState({
        queryExpanded: !this.state.queryExpanded,
        documentQuery: willToggleOff ? this.props.indexPrivilege.query : this.state.documentQuery
      });

      // If turning off, then remove the query from the Index Privilege
      if (willToggleOff) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          query: ''
        });
      }

      // If turning on, then restore the saved query if available
      if (willToggleOn && !this.props.indexPrivilege.query && this.state.documentQuery) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          query: this.state.documentQuery
        });
      }
    });
    (0, _defineProperty2.default)(this, "toggleFieldSecurity", () => {
      const willToggleOff = this.state.fieldSecurityExpanded;
      const willToggleOn = !willToggleOff;
      const {
        grant,
        except
      } = this.getFieldSecurity(this.props.indexPrivilege);

      // If turning off, then save the current configuration in state so that we can restore it if the user changes their mind.
      this.setState({
        fieldSecurityExpanded: !this.state.fieldSecurityExpanded,
        grantedFields: willToggleOff ? grant : this.state.grantedFields,
        exceptedFields: willToggleOff ? except : this.state.exceptedFields
      });

      // If turning off, then remove the field security from the Index Privilege
      if (willToggleOff) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          field_security: {
            grant: ['*'],
            except: []
          }
        });
      }

      // If turning on, then restore the saved field security if available
      const hasConfiguredFieldSecurity = this.isFieldSecurityConfigured(this.props.indexPrivilege);
      const hasSavedFieldSecurity = this.state.exceptedFields.length > 0 || this.state.grantedFields.length > 0;

      // If turning on, then request available fields
      if (willToggleOn) {
        this.loadFLSOptions(this.props.indexPrivilege.names);
      }
      if (willToggleOn && !hasConfiguredFieldSecurity && hasSavedFieldSecurity) {
        this.props.onChange({
          ...this.props.indexPrivilege,
          field_security: {
            grant: this.state.grantedFields,
            except: this.state.exceptedFields
          }
        });
      }
    });
    (0, _defineProperty2.default)(this, "onCreateClusterOption", option => {
      const nextClusters = ('clusters' in this.props.indexPrivilege && this.props.indexPrivilege.clusters ? this.props.indexPrivilege.clusters : []).concat([option]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        clusters: nextClusters
      });
    });
    (0, _defineProperty2.default)(this, "onClustersChange", nextOptions => {
      const clusters = nextOptions.map(fromOption);
      this.props.onChange({
        ...this.props.indexPrivilege,
        clusters
      });
    });
    (0, _defineProperty2.default)(this, "onCreateIndexPatternOption", option => {
      const newIndexPatterns = this.props.indexPrivilege.names.concat([option]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        names: newIndexPatterns
      });
      // If FLS controls are visible, then forcefully request a new set of options
      if (this.state.fieldSecurityExpanded) {
        this.loadFLSOptions(newIndexPatterns, true);
      }
    });
    (0, _defineProperty2.default)(this, "onIndexPatternsChange", newPatterns => {
      const names = newPatterns.map(fromOption);
      this.props.onChange({
        ...this.props.indexPrivilege,
        names
      });
      // If FLS controls are visible, then forcefully request a new set of options
      if (this.state.fieldSecurityExpanded) {
        this.loadFLSOptions(names, true);
      }
    });
    (0, _defineProperty2.default)(this, "onPrivilegeChange", newPrivileges => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        privileges: newPrivileges.map(fromOption)
      });
    });
    (0, _defineProperty2.default)(this, "onCreateCustomPrivilege", customPrivilege => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        privileges: [...this.props.indexPrivilege.privileges, customPrivilege]
      });
    });
    (0, _defineProperty2.default)(this, "onQueryChange", query => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        query
      });
    });
    (0, _defineProperty2.default)(this, "onCreateGrantedField", grant => {
      if (!this.props.indexPrivilege.field_security || !this.props.indexPrivilege.field_security.grant) {
        return;
      }
      const newGrants = this.props.indexPrivilege.field_security.grant.concat([grant]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          grant: newGrants
        }
      });
    });
    (0, _defineProperty2.default)(this, "onGrantedFieldsChange", grantedFields => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          grant: grantedFields.map(fromOption)
        }
      });
    });
    (0, _defineProperty2.default)(this, "onCreateDeniedField", except => {
      if (!this.props.indexPrivilege.field_security || !this.props.indexPrivilege.field_security.except) {
        return;
      }
      const newExcepts = this.props.indexPrivilege.field_security.except.concat([except]);
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          except: newExcepts
        }
      });
    });
    (0, _defineProperty2.default)(this, "onDeniedFieldsChange", deniedFields => {
      this.props.onChange({
        ...this.props.indexPrivilege,
        field_security: {
          ...this.props.indexPrivilege.field_security,
          except: deniedFields.map(fromOption)
        }
      });
    });
    (0, _defineProperty2.default)(this, "getFieldSecurity", indexPrivilege => {
      const {
        grant = [],
        except = []
      } = indexPrivilege.field_security || {};
      return {
        grant,
        except
      };
    });
    (0, _defineProperty2.default)(this, "isFieldSecurityConfigured", indexPrivilege => {
      const {
        grant,
        except
      } = this.getFieldSecurity(indexPrivilege);
      return except.length > 0 || grant.length > 0 && !_lodash.default.isEqual(grant, ['*']);
    });
    const {
      grant: _grant,
      except: _except
    } = this.getFieldSecurity(props.indexPrivilege);
    this.state = {
      queryExpanded: !!props.indexPrivilege.query,
      fieldSecurityExpanded: this.isFieldSecurityConfigured(props.indexPrivilege),
      grantedFields: _grant,
      exceptedFields: _except,
      documentQuery: props.indexPrivilege.query,
      documentQueryEditorHeight: '100px',
      isFieldListLoading: false,
      flsOptions: []
    };
  }
  componentDidMount() {
    if (this.state.fieldSecurityExpanded && this.props.allowFieldLevelSecurity) {
      this.loadFLSOptions(this.props.indexPrivilege.names);
    }
  }
  render() {
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      className: "index-privilege-form",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, this.getPrivilegeForm())), !this.props.isRoleReadOnly && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": this.props.indexType === 'remote_indices' ? _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deleteRemoteIndexPrivilegeAriaLabel', {
        defaultMessage: 'Delete remote index privilege'
      }) : _i18n.i18n.translate('xpack.security.management.editRole.indexPrivilegeForm.deleteIndexPrivilegeAriaLabel', {
        defaultMessage: 'Delete index privilege'
      }),
      color: 'danger',
      onClick: this.props.onDelete,
      iconType: 'trash',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }))));
  }
}
exports.IndexPrivilegeForm = IndexPrivilegeForm;