"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddRuleButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/add_rule_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddRuleButton = props => {
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    "data-test-subj": "roleMappingsAddRuleButton",
    onClick: () => {
      setIsMenuOpen(!isMenuOpen);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleButton",
    defaultMessage: "Add",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
  const options = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    id: "addRuleOption",
    key: "rule",
    name: "Add rule",
    icon: "user",
    onClick: () => {
      setIsMenuOpen(false);
      props.onClick(new _model.FieldRule('username', '*'));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleOption",
    defaultMessage: "Add rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    id: "addRuleGroupOption",
    key: "ruleGroup",
    name: "Add rule group",
    icon: "list",
    onClick: () => {
      setIsMenuOpen(false);
      props.onClick(new _model.AllRule([new _model.FieldRule('username', '*')]));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.addRuleGroupOption",
    defaultMessage: "Add rule group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "addRuleContextMenu",
    "data-test-subj": "addRuleContextMenu",
    button: button,
    isOpen: isMenuOpen,
    closePopover: () => setIsMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    title: "Add rule",
    items: options,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }));
};
exports.AddRuleButton = AddRuleButton;