"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnonymousAccessService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ANONYMOUS_ACCESS_STATE = Object.freeze({
  isEnabled: false,
  accessURLParameters: null
});
/**
 * Service that allows to retrieve application state.
 */
class AnonymousAccessService {
  constructor() {
    (0, _defineProperty2.default)(this, "internalService", void 0);
  }
  setup({
    share
  }) {
    share.setAnonymousAccessServiceProvider(() => this.internalService);
  }
  start({
    http
  }) {
    this.internalService = {
      getCapabilities: () => http.get('/internal/security/anonymous_access/capabilities'),
      getState: () => http.anonymousPaths.isAnonymous(window.location.pathname) ? Promise.resolve(DEFAULT_ANONYMOUS_ACCESS_STATE) : http.get('/internal/security/anonymous_access/state').catch(() => DEFAULT_ANONYMOUS_ACCESS_STATE)
    };
  }
}
exports.AnonymousAccessService = AnonymousAccessService;