"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _styles = require("./styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sharedStyles = (0, _styles.useStyles)();
  return {
    // Import shared styles
    ...sharedStyles,
    // Component-specific style only used in this component
    panelBody: (0, _react.css)`
      margin-top: ${euiTheme.size.s};
      margin-left: ${euiTheme.size.l};
    `,
    // Table header styling
    tvHeader: (0, _react.css)`
      ${(0, _eui.useEuiFontSize)('xs')}
      color: ${euiTheme.colors.darkShade};
      display: table;
      width: 100%;
      table-layout: fixed;
    `
  };
};
exports.useStyles = useStyles;