"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileTree = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _index_details = require("./index_details");
var _shard_details = require("./shard_details");
var _init_data = require("./init_data");
var _highlight_context = require("./highlight_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/profile_tree/profile_tree.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    // Main profile tree container
    container: (0, _react2.css)`
      height: 100%;
      overflow-y: auto;
      flex-grow: 1;
    `,
    // Index panel container
    indexPanel: (0, _react2.css)`
      width: 100%;
      padding: ${euiTheme.size.base} ${euiTheme.size.s};
      border-bottom: ${euiTheme.border.thin};
    `
  };
};
const ProfileTree = exports.ProfileTree = /*#__PURE__*/(0, _react.memo)(({
  data,
  target,
  onHighlight,
  onDataInitError
}) => {
  const styles = useStyles();
  let content = null;
  if (data && data.length) {
    try {
      const sortedIndices = (0, _init_data.initDataFor)(target)(data);
      content = /*#__PURE__*/_react.default.createElement(_highlight_context.HighlightContextProvider, {
        onHighlight: onHighlight,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }, sortedIndices.map(index => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: index.name,
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        css: styles.indexPanel,
        gutterSize: "none",
        key: index.name,
        direction: "column",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_index_details.IndexDetails, {
        index: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 19
        }
      }, index.shards.map((shard, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: shard.id[1] + `_${idx}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_shard_details.ShardDetails, {
        index: index,
        shard: shard,
        operations: shard[target],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 25
        }
      }), idx < index.shards.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 58
        }
      }) : undefined))))))));
    } catch (e) {
      onDataInitError(e);
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "profileTree",
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, content);
});