"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightDetailsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lib = require("../../lib");
var _highlight_details_table = require("./highlight_details_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/highlight_details_flyout/highlight_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      max-width: ${euiTheme.breakpoint.s}px;
    `
  };
};
const FlyoutEntry = ({
  title,
  body
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("dt", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}, title), /*#__PURE__*/_react.default.createElement("dd", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 5
  }
}, body));
const HighlightDetailsFlyout = ({
  indexName,
  operation,
  shardName,
  onClose
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const styles = useStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    css: styles.container,
    onClose: () => onClose(),
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, indexName), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, shardName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("dl", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.typeTitle', {
      defaultMessage: 'Type'
    }),
    body: operation.query_type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.descriptionTitle', {
      defaultMessage: 'Description'
    }),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 21
      }
    }, operation.lucene),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.totalTimeTitle', {
      defaultMessage: 'Total time'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.totalTimeTooltip', {
        defaultMessage: 'The total time spent at this query component, inclusive of children'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 19
      }
    })),
    body: (0, _lib.msToPretty)(operation.time, 3),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.selfTimeTitle', {
      defaultMessage: 'Self time'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "info",
      color: "subdued",
      content: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.selfTimeTooltip', {
        defaultMessage: 'The time spent by this query component alone, exclusive of children'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 19
      }
    })),
    body: (0, _lib.msToPretty)(operation.selfTime || 0, 3),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(FlyoutEntry, {
    title: _i18n.i18n.translate('xpack.searchProfiler.highlightDetails.timingBreakdownTitle', {
      defaultMessage: 'Timing breakdown'
    }),
    body: /*#__PURE__*/_react.default.createElement(_highlight_details_table.HighlightDetailsTable, {
      breakdown: operation.breakdown,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  })))));
};
exports.HighlightDetailsFlyout = HighlightDetailsFlyout;