"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleDataActionButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_sample_data_status = require("../../hooks/use_sample_data_status");
var _use_kibana = require("../../hooks/use_kibana");
var _utils = require("../utils");
var _use_navigate_to_discover = require("../../hooks/use_navigate_to_discover");
var _use_navigate_to_dashboard = require("../../hooks/use_navigate_to_dashboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764763494416240164/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/sample_data_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SampleDataActionButton = ({
  onIngestSampleData,
  hasRequiredLicense
}) => {
  const {
    application,
    http,
    share,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const {
    isInstalled,
    indexName,
    dashboardId,
    isLoading: isStatusLoading,
    isInstalling
  } = (0, _use_sample_data_status.useSampleDataStatus)();
  const [isShowViewDataOptions, setShowViewDataOptions] = (0, _react.useState)(false);
  const isAgentBuilderAvailable = uiSettings.get(_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID, false);
  const onViewButtonClick = (0, _react.useCallback)(() => {
    setShowViewDataOptions(true);
  }, []);
  const onClosePopover = (0, _react.useCallback)(() => {
    setShowViewDataOptions(false);
  }, []);
  const navigateToPlayground = (0, _react.useCallback)(async () => {
    const playgroundLocator = share.url.locators.get('PLAYGROUND_LOCATOR_ID');
    const isSearchAvailable = uiSettings.get('searchPlayground:searchModeEnabled', false);
    if (playgroundLocator && indexName) {
      await playgroundLocator.navigate({
        'default-index': indexName,
        search: isSearchAvailable
      });
    }
  }, [share, uiSettings, indexName]);
  const navigateToDiscover = (0, _use_navigate_to_discover.useNavigateToDiscover)(indexName || '');
  const navigateToDashboard = (0, _use_navigate_to_dashboard.useNavigateToDashboard)(dashboardId);
  const navigateToAgentBuilder = (0, _react.useCallback)(async () => {
    if (isAgentBuilderAvailable) {
      const agentBuilderLocator = share.url.locators.get('AGENT_BUILDER_LOCATOR_ID');
      await (agentBuilderLocator === null || agentBuilderLocator === void 0 ? void 0 : agentBuilderLocator.navigate({}));
    }
  }, [share, isAgentBuilderAvailable]);
  if (isStatusLoading) {
    return null;
  }
  if (isInstalled && indexName) {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "viewDataBtn",
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onViewButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchIndices.shared.createIndex.ingestSampleData.view",
      defaultMessage: "View Data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: isShowViewDataOptions,
      closePopover: onClosePopover,
      anchorPosition: "downLeft",
      panelPaddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      css: {
        minWidth: 250
      },
      items: [...(isAgentBuilderAvailable ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "agentBuilder",
        onClick: navigateToAgentBuilder,
        icon: "comment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchIndices.shared.createIndex.ingestSampleData.linkToAgentBuilder",
        defaultMessage: "Agents",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 23
        }
      }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "discover",
        onClick: navigateToDiscover,
        icon: "discoverApp",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchIndices.shared.createIndex.ingestSampleData.linkToDiscover",
        defaultMessage: "Discover",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 17
        }
      })), ...(dashboardId ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "dashboard",
        onClick: navigateToDashboard,
        icon: "dashboardApp",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchIndices.shared.createIndex.ingestSampleData.linkToDashboard",
        defaultMessage: "Dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 23
        }
      }))] : []), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "playground",
        onClick: navigateToPlayground,
        icon: "comment",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchIndices.shared.createIndex.ingestSampleData.linkToPlayground",
        defaultMessage: "Playground",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "index",
        onClick: () => {
          (0, _utils.navigateToIndexDetails)(application, http, indexName);
        },
        icon: "index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchIndices.shared.createIndex.ingestSampleData.linkToIndex",
        defaultMessage: "View index",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 17
        }
      }))],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    })));
  }
  const installButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    iconSide: "left",
    iconType: "download",
    size: "s",
    "data-test-subj": "installSampleBtn",
    isLoading: isInstalling,
    disabled: !hasRequiredLicense,
    onClick: onIngestSampleData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchIndices.shared.createIndex.ingestSampleData.btn",
    defaultMessage: "Install a sample dataset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }));
  return hasRequiredLicense ? installButton : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    title: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.ingestSampleData.licenseTooltip.title', {
      defaultMessage: 'Enterprise'
    }),
    content: _i18n.i18n.translate('xpack.searchIndices.shared.createIndex.ingestSampleData.licenseTooltip.description', {
      defaultMessage: 'This dataset makes use of AI features that require an Enterprise license.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, installButton);
};
exports.SampleDataActionButton = SampleDataActionButton;